/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import com.sucy.skill.hook.VaultHook;
import java.util.List;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class MoneyMechanic
extends MechanicComponent {
    private static final String TYPE = "type";
    private static final String AMOUNT = "amount";
    private static final String ALLOWS_NEGATIVE = "allows_negative";

    @Override
    public String getKey() {
        return "money";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (!VaultHook.isEconomyValid()) {
            return false;
        }
        boolean multiply = this.settings.getString(TYPE, "add").equalsIgnoreCase("multiply");
        double amount = this.parseValues(caster, AMOUNT, level, 1.0);
        boolean allowsNegative = this.settings.getBool(ALLOWS_NEGATIVE, false);
        boolean worked = false;
        for (LivingEntity target : targets) {
            double difference;
            if (!(target instanceof Player)) continue;
            Player player = (Player)target;
            double balance = VaultHook.getBalance(player);
            double d = difference = multiply ? balance * (amount - 1.0) : amount;
            if (!allowsNegative && balance + difference < 0.0) continue;
            EconomyResponse.ResponseType result = null;
            if (difference > 0.0) {
                result = VaultHook.deposit((Player)player, (double)difference).type;
            } else if (difference < 0.0) {
                result = VaultHook.withdraw((Player)player, (double)(-difference)).type;
            }
            if (result != EconomyResponse.ResponseType.SUCCESS) continue;
            worked = true;
        }
        return worked;
    }
}

