/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.api.util.Buff;
import com.sucy.skill.api.util.BuffManager;
import com.sucy.skill.api.util.BuffType;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import com.sucy.skill.hook.PluginChecker;
import com.sucy.skill.listener.PacketListener;
import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class InvisibilityMechanic
extends MechanicComponent {
    @Override
    public String getKey() {
        return "invisibility";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        int duration = this.settings.getInt("duration", 20);
        boolean hideEquipment = this.settings.getBool("hideEquipment", false);
        PotionEffect potion = new PotionEffect(PotionEffectType.INVISIBILITY, duration, 0, false, false, true);
        targets.forEach(c -> c.addPotionEffect(potion));
        if (!hideEquipment || !PluginChecker.isProtocolLibActive()) {
            return true;
        }
        targets.forEach(target -> {
            if (!(target instanceof Player)) {
                return;
            }
            BuffManager.addBuff(target, BuffType.INVISIBILITY, new Buff(this.skill.getName(), 0.0, false), duration);
            PacketListener.updateEquipment((Player)target);
        });
        return true;
    }
}

