/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.util.FlagManager;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.Metadatable;

public class ImmunityMechanic
extends MechanicComponent {
    public static final String META_KEY = "sapi_immunity";
    private static final String TYPE = "type";
    private static final String SECONDS = "seconds";
    private static final String MULTIPLIER = "multiplier";

    @Override
    public String getKey() {
        return "immunity";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0 || !this.settings.has(TYPE)) {
            return false;
        }
        String key = this.settings.getString(TYPE);
        double seconds = this.parseValues(caster, SECONDS, level, 3.0);
        double multiplier = this.parseValues(caster, MULTIPLIER, level, 0.0);
        int ticks = (int)(seconds * 20.0);
        for (LivingEntity target : targets) {
            FlagManager.addFlag(target, "immune:" + key.toUpperCase().replace(" ", "_"), ticks);
            SkillAPI.setMeta((Metadatable)target, META_KEY, multiplier);
        }
        return targets.size() > 0;
    }
}

