/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.api.event.SkillHealEvent;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import mc.promcteam.engine.mccore.util.VersionManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

public class HealMechanic
extends MechanicComponent {
    private static final String TYPE = "type";
    private static final String VALUE = "value";

    @Override
    public String getKey() {
        return "heal";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        boolean percent = this.settings.getString(TYPE, "health").toLowerCase().equals("percent");
        double value = this.parseValues(caster, VALUE, level, 1.0);
        if (value < 0.0) {
            return false;
        }
        for (LivingEntity target : targets) {
            if (target.isDead()) continue;
            double amount = value;
            if (percent) {
                amount = target.getMaxHealth() * value / 100.0;
            }
            SkillHealEvent event = new SkillHealEvent(caster, target, amount);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            VersionManager.heal((LivingEntity)target, (double)event.getAmount());
        }
        return targets.size() > 0;
    }
}

