/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.condition;

import com.sucy.skill.dynamic.condition.ConditionComponent;
import org.bukkit.entity.LivingEntity;

public class HealthCondition
extends ConditionComponent {
    private static final String TYPE = "type";
    private static final String MIN = "min-value";
    private static final String MAX = "max-value";

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        String type = this.settings.getString(TYPE).toLowerCase();
        double min = this.parseValues(caster, MIN, level, 0.0);
        double max = this.parseValues(caster, MAX, level, 999.0);
        double value = switch (type) {
            case "difference percent" -> (target.getHealth() - caster.getHealth()) * 100.0 / caster.getHealth();
            case "difference" -> target.getHealth() - caster.getHealth();
            case "percent" -> target.getHealth() * 100.0 / target.getMaxHealth();
            default -> target.getHealth();
        };
        return value >= min && value <= max;
    }

    @Override
    public String getKey() {
        return "health";
    }
}

