/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.dynamic.ComponentType;
import com.sucy.skill.dynamic.EffectComponent;
import com.sucy.skill.dynamic.TriggerHandler;
import com.sucy.skill.dynamic.condition.AltitudeCondition;
import com.sucy.skill.dynamic.condition.ArmorCondition;
import com.sucy.skill.dynamic.condition.AttributeCondition;
import com.sucy.skill.dynamic.condition.BiomeCondition;
import com.sucy.skill.dynamic.condition.BlockCondition;
import com.sucy.skill.dynamic.condition.BurningCondition;
import com.sucy.skill.dynamic.condition.CastLevelCondition;
import com.sucy.skill.dynamic.condition.CeilingCondition;
import com.sucy.skill.dynamic.condition.ChanceCondition;
import com.sucy.skill.dynamic.condition.ClassCondition;
import com.sucy.skill.dynamic.condition.ClassLevelCondition;
import com.sucy.skill.dynamic.condition.CombatCondition;
import com.sucy.skill.dynamic.condition.CrouchCondition;
import com.sucy.skill.dynamic.condition.DirectionCondition;
import com.sucy.skill.dynamic.condition.ElevationCondition;
import com.sucy.skill.dynamic.condition.ElseCondition;
import com.sucy.skill.dynamic.condition.EntityTypeCondition;
import com.sucy.skill.dynamic.condition.FireCondition;
import com.sucy.skill.dynamic.condition.FlagCondition;
import com.sucy.skill.dynamic.condition.FoodCondition;
import com.sucy.skill.dynamic.condition.GroundCondition;
import com.sucy.skill.dynamic.condition.HealthCondition;
import com.sucy.skill.dynamic.condition.InventoryCondition;
import com.sucy.skill.dynamic.condition.ItemCondition;
import com.sucy.skill.dynamic.condition.LightCondition;
import com.sucy.skill.dynamic.condition.LoreCondition;
import com.sucy.skill.dynamic.condition.ManaCondition;
import com.sucy.skill.dynamic.condition.MoneyCondition;
import com.sucy.skill.dynamic.condition.MountedCondition;
import com.sucy.skill.dynamic.condition.MountingCondition;
import com.sucy.skill.dynamic.condition.MythicMobTypeCondition;
import com.sucy.skill.dynamic.condition.NameCondition;
import com.sucy.skill.dynamic.condition.OffhandCondition;
import com.sucy.skill.dynamic.condition.PermissionCondition;
import com.sucy.skill.dynamic.condition.PotionCondition;
import com.sucy.skill.dynamic.condition.SkillLevelCondition;
import com.sucy.skill.dynamic.condition.SlotCondition;
import com.sucy.skill.dynamic.condition.StatusCondition;
import com.sucy.skill.dynamic.condition.TimeCondition;
import com.sucy.skill.dynamic.condition.ToolCondition;
import com.sucy.skill.dynamic.condition.ValueCondition;
import com.sucy.skill.dynamic.condition.ValueTextCondition;
import com.sucy.skill.dynamic.condition.WaterCondition;
import com.sucy.skill.dynamic.condition.WeatherCondition;
import com.sucy.skill.dynamic.condition.WorldCondition;
import com.sucy.skill.dynamic.custom.CustomComponent;
import com.sucy.skill.dynamic.custom.CustomEffectComponent;
import com.sucy.skill.dynamic.custom.EditorOption;
import com.sucy.skill.dynamic.mechanic.ArmorMechanic;
import com.sucy.skill.dynamic.mechanic.ArmorStandMechanic;
import com.sucy.skill.dynamic.mechanic.ArmorStandPoseMechanic;
import com.sucy.skill.dynamic.mechanic.AttributeMechanic;
import com.sucy.skill.dynamic.mechanic.BlockMechanic;
import com.sucy.skill.dynamic.mechanic.BuffMechanic;
import com.sucy.skill.dynamic.mechanic.CancelEffectMechanic;
import com.sucy.skill.dynamic.mechanic.CancelMechanic;
import com.sucy.skill.dynamic.mechanic.ChannelMechanic;
import com.sucy.skill.dynamic.mechanic.CleanseMechanic;
import com.sucy.skill.dynamic.mechanic.CommandMechanic;
import com.sucy.skill.dynamic.mechanic.CooldownMechanic;
import com.sucy.skill.dynamic.mechanic.DamageBuffMechanic;
import com.sucy.skill.dynamic.mechanic.DamageLoreMechanic;
import com.sucy.skill.dynamic.mechanic.DamageMechanic;
import com.sucy.skill.dynamic.mechanic.DefenseBuffMechanic;
import com.sucy.skill.dynamic.mechanic.DelayMechanic;
import com.sucy.skill.dynamic.mechanic.DisguiseMechanic;
import com.sucy.skill.dynamic.mechanic.DurabilityMechanic;
import com.sucy.skill.dynamic.mechanic.ExperienceMechanic;
import com.sucy.skill.dynamic.mechanic.ExplosionMechanic;
import com.sucy.skill.dynamic.mechanic.FireMechanic;
import com.sucy.skill.dynamic.mechanic.FlagClearMechanic;
import com.sucy.skill.dynamic.mechanic.FlagMechanic;
import com.sucy.skill.dynamic.mechanic.FlagToggleMechanic;
import com.sucy.skill.dynamic.mechanic.FoodMechanic;
import com.sucy.skill.dynamic.mechanic.ForgetTargetsMechanic;
import com.sucy.skill.dynamic.mechanic.HealMechanic;
import com.sucy.skill.dynamic.mechanic.HealthSetMechanic;
import com.sucy.skill.dynamic.mechanic.HeldItemMechanic;
import com.sucy.skill.dynamic.mechanic.ImmunityMechanic;
import com.sucy.skill.dynamic.mechanic.InterruptMechanic;
import com.sucy.skill.dynamic.mechanic.InvisibilityMechanic;
import com.sucy.skill.dynamic.mechanic.ItemDropMechanic;
import com.sucy.skill.dynamic.mechanic.ItemMechanic;
import com.sucy.skill.dynamic.mechanic.ItemProjectileMechanic;
import com.sucy.skill.dynamic.mechanic.ItemRemoveMechanic;
import com.sucy.skill.dynamic.mechanic.LaunchMechanic;
import com.sucy.skill.dynamic.mechanic.LightningMechanic;
import com.sucy.skill.dynamic.mechanic.ManaMechanic;
import com.sucy.skill.dynamic.mechanic.MessageMechanic;
import com.sucy.skill.dynamic.mechanic.MineMechanic;
import com.sucy.skill.dynamic.mechanic.MoneyMechanic;
import com.sucy.skill.dynamic.mechanic.ParticleAnimationMechanic;
import com.sucy.skill.dynamic.mechanic.ParticleEffectMechanic;
import com.sucy.skill.dynamic.mechanic.ParticleMechanic;
import com.sucy.skill.dynamic.mechanic.ParticleProjectileMechanic;
import com.sucy.skill.dynamic.mechanic.PassiveMechanic;
import com.sucy.skill.dynamic.mechanic.PermissionMechanic;
import com.sucy.skill.dynamic.mechanic.PotionMechanic;
import com.sucy.skill.dynamic.mechanic.PotionProjectileMechanic;
import com.sucy.skill.dynamic.mechanic.ProjectileMechanic;
import com.sucy.skill.dynamic.mechanic.PurgeMechanic;
import com.sucy.skill.dynamic.mechanic.PushMechanic;
import com.sucy.skill.dynamic.mechanic.RememberTargetsMechanic;
import com.sucy.skill.dynamic.mechanic.RepeatMechanic;
import com.sucy.skill.dynamic.mechanic.SignalEmitMechanic;
import com.sucy.skill.dynamic.mechanic.SkillCastMechanic;
import com.sucy.skill.dynamic.mechanic.SoundMechanic;
import com.sucy.skill.dynamic.mechanic.StatMechanic;
import com.sucy.skill.dynamic.mechanic.StatusMechanic;
import com.sucy.skill.dynamic.mechanic.TauntMechanic;
import com.sucy.skill.dynamic.mechanic.TriggerMechanic;
import com.sucy.skill.dynamic.mechanic.ValueAddMechanic;
import com.sucy.skill.dynamic.mechanic.ValueAttributeMechanic;
import com.sucy.skill.dynamic.mechanic.ValueCopyMechanic;
import com.sucy.skill.dynamic.mechanic.ValueDistanceMechanic;
import com.sucy.skill.dynamic.mechanic.ValueHealthMechanic;
import com.sucy.skill.dynamic.mechanic.ValueLoadMechanic;
import com.sucy.skill.dynamic.mechanic.ValueLocationMechanic;
import com.sucy.skill.dynamic.mechanic.ValueLoreMechanic;
import com.sucy.skill.dynamic.mechanic.ValueLoreSlotMechanic;
import com.sucy.skill.dynamic.mechanic.ValueManaMechanic;
import com.sucy.skill.dynamic.mechanic.ValueMultiplyMechanic;
import com.sucy.skill.dynamic.mechanic.ValuePlaceholderMechanic;
import com.sucy.skill.dynamic.mechanic.ValueRandomMechanic;
import com.sucy.skill.dynamic.mechanic.ValueSetMechanic;
import com.sucy.skill.dynamic.mechanic.WarpLocMechanic;
import com.sucy.skill.dynamic.mechanic.WarpMechanic;
import com.sucy.skill.dynamic.mechanic.WarpRandomMechanic;
import com.sucy.skill.dynamic.mechanic.WarpSwapMechanic;
import com.sucy.skill.dynamic.mechanic.WarpTargetMechanic;
import com.sucy.skill.dynamic.mechanic.WarpValueMechanic;
import com.sucy.skill.dynamic.mechanic.WolfMechanic;
import com.sucy.skill.dynamic.target.AreaTarget;
import com.sucy.skill.dynamic.target.ConeTarget;
import com.sucy.skill.dynamic.target.LinearTarget;
import com.sucy.skill.dynamic.target.LocationTarget;
import com.sucy.skill.dynamic.target.NearestTarget;
import com.sucy.skill.dynamic.target.OffsetTarget;
import com.sucy.skill.dynamic.target.RememberTarget;
import com.sucy.skill.dynamic.target.SelfTarget;
import com.sucy.skill.dynamic.target.SingleTarget;
import com.sucy.skill.dynamic.trigger.ArmorEquipTrigger;
import com.sucy.skill.dynamic.trigger.BlockBreakTrigger;
import com.sucy.skill.dynamic.trigger.BlockPlaceTrigger;
import com.sucy.skill.dynamic.trigger.ChatTrigger;
import com.sucy.skill.dynamic.trigger.ClickLeftTrigger;
import com.sucy.skill.dynamic.trigger.ClickRightTrigger;
import com.sucy.skill.dynamic.trigger.ConsumeTrigger;
import com.sucy.skill.dynamic.trigger.CrouchTrigger;
import com.sucy.skill.dynamic.trigger.DeathTrigger;
import com.sucy.skill.dynamic.trigger.DropItemTrigger;
import com.sucy.skill.dynamic.trigger.EnvironmentalTrigger;
import com.sucy.skill.dynamic.trigger.FishingBiteTrigger;
import com.sucy.skill.dynamic.trigger.FishingFailTrigger;
import com.sucy.skill.dynamic.trigger.FishingFishTrigger;
import com.sucy.skill.dynamic.trigger.FishingGrabTrigger;
import com.sucy.skill.dynamic.trigger.FishingGroundTrigger;
import com.sucy.skill.dynamic.trigger.FishingReelTrigger;
import com.sucy.skill.dynamic.trigger.HealTrigger;
import com.sucy.skill.dynamic.trigger.ItemSwapTrigger;
import com.sucy.skill.dynamic.trigger.KillTrigger;
import com.sucy.skill.dynamic.trigger.LandTrigger;
import com.sucy.skill.dynamic.trigger.LaunchTrigger;
import com.sucy.skill.dynamic.trigger.MoveTrigger;
import com.sucy.skill.dynamic.trigger.PhysicalDealtTrigger;
import com.sucy.skill.dynamic.trigger.PhysicalTakenTrigger;
import com.sucy.skill.dynamic.trigger.ProjectileHitTrigger;
import com.sucy.skill.dynamic.trigger.ProjectileTickTrigger;
import com.sucy.skill.dynamic.trigger.ShieldTrigger;
import com.sucy.skill.dynamic.trigger.SignalTrigger;
import com.sucy.skill.dynamic.trigger.SkillCastTrigger;
import com.sucy.skill.dynamic.trigger.SkillDealtTrigger;
import com.sucy.skill.dynamic.trigger.SkillTakenTrigger;
import com.sucy.skill.dynamic.trigger.Trigger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.Event;
import org.bukkit.plugin.EventExecutor;

public class ComponentRegistry {
    static final Map<ComponentType, Map<String, Class<?>>> COMPONENTS = new EnumMap(ComponentType.class);
    static final Map<String, Trigger<?>> TRIGGERS = new HashMap();
    private static final Map<Trigger<?>, EventExecutor> EXECUTORS = new HashMap();

    public static Trigger<?> getTrigger(String key) {
        return TRIGGERS.get(key.toUpperCase().replace(' ', '_'));
    }

    static EffectComponent getComponent(ComponentType type, String key) {
        Class<?> componentClass = COMPONENTS.get((Object)type).get(key.toLowerCase());
        if (componentClass == null) {
            throw new IllegalArgumentException("Invalid component key - " + key);
        }
        try {
            return (EffectComponent)componentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid component - does not have a default constructor");
        }
    }

    static EventExecutor getExecutor(Trigger<?> trigger) {
        return EXECUTORS.get(trigger);
    }

    public static <T extends Event> void register(Trigger<T> trigger) {
        if (ComponentRegistry.getTrigger(trigger.getKey()) != null) {
            throw new IllegalArgumentException("Trigger with key " + trigger.getKey() + " already exists");
        }
        if (trigger.getKey().contains("-")) {
            throw new IllegalArgumentException(trigger.getKey() + " is not a valid key: must not contain dashes");
        }
        TRIGGERS.put(trigger.getKey(), trigger);
        EXECUTORS.put(trigger, (listener, event) -> {
            if (!trigger.getEvent().isInstance(event)) {
                return;
            }
            ((TriggerHandler)listener).apply(event, trigger);
        });
    }

    public static void register(CustomEffectComponent component) {
        ComponentRegistry.register((EffectComponent)component);
    }

    public static void save() {
        StringBuilder builder = new StringBuilder("[");
        TRIGGERS.values().forEach(trigger -> ComponentRegistry.append(trigger, builder));
        COMPONENTS.forEach((type, map) -> map.keySet().forEach(key -> ComponentRegistry.append(ComponentRegistry.getComponent(type, key), builder)));
        if (builder.length() > 2) {
            builder.replace(builder.length() - 1, builder.length(), "]");
        } else {
            builder.append(']');
        }
        File file = new File(SkillAPI.inst().getDataFolder(), "tool-config.json");
        try (FileOutputStream out = new FileOutputStream(file);){
            BufferedWriter write = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            write.write(builder.toString());
            write.close();
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
    }

    private static void append(Object obj, StringBuilder builder) {
        if (!(obj instanceof CustomComponent)) {
            return;
        }
        CustomComponent component = (CustomComponent)obj;
        builder.append("{\"type\":\"").append(component.getType().name()).append("\",\"key\":\"").append(component.getKey()).append("\",\"display\":\"").append(component.getDisplayName()).append("\",\"container\":\"").append(component.isContainer()).append("\",\"description\":\"").append(component.getDescription()).append("\",\"options\":[");
        boolean first = true;
        for (EditorOption option : component.getOptions()) {
            if (!first) {
                builder.append(',');
            }
            first = false;
            builder.append("{\"type\":\"").append((Object)option.type).append("\",\"key\":\"").append(option.key).append("\",\"display\":\"").append(option.name).append("\",\"description\":\"").append(option.description).append("\"");
            option.extra.forEach((key, value) -> builder.append(",\"").append((String)key).append("\":").append((String)value));
            builder.append("}");
        }
        builder.append("]},");
    }

    private static void register(EffectComponent component) {
        COMPONENTS.computeIfAbsent(component.getType(), t -> new HashMap()).put(component.getKey().toLowerCase(), component.getClass());
    }

    static {
        ComponentRegistry.register(new ArmorEquipTrigger());
        ComponentRegistry.register(new BlockBreakTrigger());
        ComponentRegistry.register(new BlockPlaceTrigger());
        ComponentRegistry.register(new ChatTrigger());
        ComponentRegistry.register(new ClickLeftTrigger());
        ComponentRegistry.register(new ClickRightTrigger());
        ComponentRegistry.register(new CrouchTrigger());
        ComponentRegistry.register(new DeathTrigger());
        ComponentRegistry.register(new DropItemTrigger());
        ComponentRegistry.register(new EnvironmentalTrigger());
        ComponentRegistry.register(new FishingBiteTrigger());
        ComponentRegistry.register(new FishingFailTrigger());
        ComponentRegistry.register(new FishingFishTrigger());
        ComponentRegistry.register(new FishingGrabTrigger());
        ComponentRegistry.register(new FishingGroundTrigger());
        ComponentRegistry.register(new FishingReelTrigger());
        ComponentRegistry.register(new HealTrigger());
        ComponentRegistry.register(new ItemSwapTrigger());
        ComponentRegistry.register(new KillTrigger());
        ComponentRegistry.register(new LandTrigger());
        ComponentRegistry.register(new LaunchTrigger());
        ComponentRegistry.register(new MoveTrigger());
        ComponentRegistry.register(new PhysicalDealtTrigger());
        ComponentRegistry.register(new PhysicalTakenTrigger());
        ComponentRegistry.register(new ProjectileHitTrigger());
        ComponentRegistry.register(new ProjectileTickTrigger());
        ComponentRegistry.register(new SkillDealtTrigger());
        ComponentRegistry.register(new SkillTakenTrigger());
        ComponentRegistry.register(new ShieldTrigger());
        ComponentRegistry.register(new SignalTrigger());
        ComponentRegistry.register(new SkillCastTrigger());
        ComponentRegistry.register(new ConsumeTrigger());
        ComponentRegistry.register(new AreaTarget());
        ComponentRegistry.register(new ConeTarget());
        ComponentRegistry.register(new LinearTarget());
        ComponentRegistry.register(new LocationTarget());
        ComponentRegistry.register(new NearestTarget());
        ComponentRegistry.register(new OffsetTarget());
        ComponentRegistry.register(new RememberTarget());
        ComponentRegistry.register(new SelfTarget());
        ComponentRegistry.register(new SingleTarget());
        ComponentRegistry.register(new AltitudeCondition());
        ComponentRegistry.register(new ArmorCondition());
        ComponentRegistry.register(new AttributeCondition());
        ComponentRegistry.register(new BiomeCondition());
        ComponentRegistry.register(new BlockCondition());
        ComponentRegistry.register(new BurningCondition());
        ComponentRegistry.register(new CastLevelCondition());
        ComponentRegistry.register(new CeilingCondition());
        ComponentRegistry.register(new ChanceCondition());
        ComponentRegistry.register(new ClassCondition());
        ComponentRegistry.register(new ClassLevelCondition());
        ComponentRegistry.register(new CombatCondition());
        ComponentRegistry.register(new CrouchCondition());
        ComponentRegistry.register(new DirectionCondition());
        ComponentRegistry.register(new ElevationCondition());
        ComponentRegistry.register(new ElseCondition());
        ComponentRegistry.register(new EntityTypeCondition());
        ComponentRegistry.register(new FireCondition());
        ComponentRegistry.register(new FlagCondition());
        ComponentRegistry.register(new FoodCondition());
        ComponentRegistry.register(new GroundCondition());
        ComponentRegistry.register(new HealthCondition());
        ComponentRegistry.register(new InventoryCondition());
        ComponentRegistry.register(new ItemCondition());
        ComponentRegistry.register(new LightCondition());
        ComponentRegistry.register(new LoreCondition());
        ComponentRegistry.register(new ManaCondition());
        ComponentRegistry.register(new MoneyCondition());
        ComponentRegistry.register(new MountedCondition());
        ComponentRegistry.register(new MountingCondition());
        ComponentRegistry.register(new MythicMobTypeCondition());
        ComponentRegistry.register(new NameCondition());
        ComponentRegistry.register(new OffhandCondition());
        ComponentRegistry.register(new PermissionCondition());
        ComponentRegistry.register(new PotionCondition());
        ComponentRegistry.register(new SkillLevelCondition());
        ComponentRegistry.register(new SlotCondition());
        ComponentRegistry.register(new StatusCondition());
        ComponentRegistry.register(new TimeCondition());
        ComponentRegistry.register(new ToolCondition());
        ComponentRegistry.register(new ValueCondition());
        ComponentRegistry.register(new ValueTextCondition());
        ComponentRegistry.register(new WaterCondition());
        ComponentRegistry.register(new WeatherCondition());
        ComponentRegistry.register(new WorldCondition());
        ComponentRegistry.register(new ArmorMechanic());
        ComponentRegistry.register(new ArmorStandMechanic());
        ComponentRegistry.register(new ArmorStandPoseMechanic());
        ComponentRegistry.register(new AttributeMechanic());
        ComponentRegistry.register(new BlockMechanic());
        ComponentRegistry.register(new BuffMechanic());
        ComponentRegistry.register(new CancelEffectMechanic());
        ComponentRegistry.register(new CancelMechanic());
        ComponentRegistry.register(new ChannelMechanic());
        ComponentRegistry.register(new CleanseMechanic());
        ComponentRegistry.register(new CommandMechanic());
        ComponentRegistry.register(new CooldownMechanic());
        ComponentRegistry.register(new DamageMechanic());
        ComponentRegistry.register(new DamageBuffMechanic());
        ComponentRegistry.register(new DamageLoreMechanic());
        ComponentRegistry.register(new DefenseBuffMechanic());
        ComponentRegistry.register(new DelayMechanic());
        ComponentRegistry.register(new DisguiseMechanic());
        ComponentRegistry.register(new DurabilityMechanic());
        ComponentRegistry.register(new ExperienceMechanic());
        ComponentRegistry.register(new ExplosionMechanic());
        ComponentRegistry.register(new FireMechanic());
        ComponentRegistry.register(new FlagMechanic());
        ComponentRegistry.register(new FlagClearMechanic());
        ComponentRegistry.register(new FlagToggleMechanic());
        ComponentRegistry.register(new FoodMechanic());
        ComponentRegistry.register(new ForgetTargetsMechanic());
        ComponentRegistry.register(new HealMechanic());
        ComponentRegistry.register(new HealthSetMechanic());
        ComponentRegistry.register(new HeldItemMechanic());
        ComponentRegistry.register(new ImmunityMechanic());
        ComponentRegistry.register(new InterruptMechanic());
        ComponentRegistry.register(new InvisibilityMechanic());
        ComponentRegistry.register(new ItemDropMechanic());
        ComponentRegistry.register(new ItemMechanic());
        ComponentRegistry.register(new ItemProjectileMechanic());
        ComponentRegistry.register(new ItemRemoveMechanic());
        ComponentRegistry.register(new LaunchMechanic());
        ComponentRegistry.register(new LightningMechanic());
        ComponentRegistry.register(new ManaMechanic());
        ComponentRegistry.register(new MessageMechanic());
        ComponentRegistry.register(new MineMechanic());
        ComponentRegistry.register(new MoneyMechanic());
        ComponentRegistry.register(new ParticleMechanic());
        ComponentRegistry.register(new ParticleAnimationMechanic());
        ComponentRegistry.register(new ParticleEffectMechanic());
        ComponentRegistry.register(new ParticleProjectileMechanic());
        ComponentRegistry.register(new PassiveMechanic());
        ComponentRegistry.register(new PermissionMechanic());
        ComponentRegistry.register(new PotionMechanic());
        ComponentRegistry.register(new PotionProjectileMechanic());
        ComponentRegistry.register(new ProjectileMechanic());
        ComponentRegistry.register(new PurgeMechanic());
        ComponentRegistry.register(new PushMechanic());
        ComponentRegistry.register(new RememberTargetsMechanic());
        ComponentRegistry.register(new RepeatMechanic());
        ComponentRegistry.register(new SignalEmitMechanic());
        ComponentRegistry.register(new SkillCastMechanic());
        ComponentRegistry.register(new StatMechanic());
        ComponentRegistry.register(new SoundMechanic());
        ComponentRegistry.register(new StatusMechanic());
        ComponentRegistry.register(new TauntMechanic());
        ComponentRegistry.register(new TriggerMechanic());
        ComponentRegistry.register(new ValueAddMechanic());
        ComponentRegistry.register(new ValueAttributeMechanic());
        ComponentRegistry.register(new ValueCopyMechanic());
        ComponentRegistry.register(new ValueDistanceMechanic());
        ComponentRegistry.register(new ValueHealthMechanic());
        ComponentRegistry.register(new ValueLoadMechanic());
        ComponentRegistry.register(new ValueLocationMechanic());
        ComponentRegistry.register(new ValueLoreMechanic());
        ComponentRegistry.register(new ValueLoreSlotMechanic());
        ComponentRegistry.register(new ValueManaMechanic());
        ComponentRegistry.register(new ValueMultiplyMechanic());
        ComponentRegistry.register(new ValuePlaceholderMechanic());
        ComponentRegistry.register(new ValueRandomMechanic());
        ComponentRegistry.register(new ValueSetMechanic());
        ComponentRegistry.register(new WarpMechanic());
        ComponentRegistry.register(new WarpLocMechanic());
        ComponentRegistry.register(new WarpRandomMechanic());
        ComponentRegistry.register(new WarpSwapMechanic());
        ComponentRegistry.register(new WarpTargetMechanic());
        ComponentRegistry.register(new WarpValueMechanic());
        ComponentRegistry.register(new WolfMechanic());
    }
}

