/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cmd;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.enums.ExpSource;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.language.RPGFilter;
import com.sucy.skill.manager.CmdManager;
import java.util.regex.Pattern;
import mc.promcteam.engine.mccore.commands.CommandManager;
import mc.promcteam.engine.mccore.commands.ConfigurableCommand;
import mc.promcteam.engine.mccore.commands.IFunction;
import mc.promcteam.engine.mccore.config.CustomFilter;
import mc.promcteam.engine.mccore.config.Filter;
import mc.promcteam.engine.mccore.config.parse.NumberParser;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CmdLevel
implements IFunction {
    private static final Pattern IS_NUMBER = Pattern.compile("-?[0-9]+");
    private static final Pattern IS_BOOL = Pattern.compile("(true)|(false)");
    private static final String NOT_PLAYER = "not-player";
    private static final String GAVE_LEVEL = "gave-level";
    private static final String RECEIVED_LEVEL = "received-level";
    private static final String DISABLED = "world-disabled";
    private static final String NO_CLASSES = "no-classes";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args) {
        if (sender instanceof Player && !SkillAPI.getSettings().isWorldEnabled(((Player)sender).getWorld()) && args.length == 1) {
            cmd.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", new CustomFilter[0]);
        } else if (args.length >= 1 && sender instanceof Player && IS_NUMBER.matcher(args[0]).matches() || args.length >= 2 && !IS_NUMBER.matcher(args[0]).matches()) {
            boolean success;
            boolean showMessage;
            OfflinePlayer target;
            int numberIndex;
            int n = numberIndex = IS_NUMBER.matcher(args[0]).matches() ? 0 : 1;
            if (args.length > 1 && IS_NUMBER.matcher(args[1]).matches()) {
                numberIndex = 1;
            }
            OfflinePlayer offlinePlayer = target = numberIndex == 0 ? (OfflinePlayer)sender : Bukkit.getOfflinePlayer((String)args[0]);
            if (target == null) {
                cmd.sendMessage(sender, NOT_PLAYER, ChatColor.RED + "That is not a valid player name", new CustomFilter[0]);
                return;
            }
            PlayerData data = SkillAPI.getPlayerData(target);
            int amount = NumberParser.parseInt((String)args[numberIndex]);
            if (amount == 0) {
                return;
            }
            int lastArg = args.length - 1;
            boolean message = IS_BOOL.matcher(args[lastArg]).matches();
            boolean bl = showMessage = !message || Boolean.parseBoolean(args[lastArg]);
            if (message) {
                --lastArg;
            }
            if (numberIndex + 1 <= lastArg) {
                PlayerClass playerClass = data.getClass(CmdManager.join(args, numberIndex + 1, lastArg));
                if (playerClass == null) {
                    CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
                    return;
                }
                if (amount > 0) {
                    playerClass.giveLevels(amount);
                } else {
                    playerClass.loseLevels(-amount);
                }
                success = true;
            } else if (amount > 0) {
                success = data.giveLevels(amount, ExpSource.COMMAND);
            } else {
                data.loseLevels(-amount);
                success = true;
            }
            if (showMessage) {
                if (!success) {
                    cmd.sendMessage(sender, NO_CLASSES, ChatColor.RED + "You aren't professed as a class that receives experience from commands", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.LEVEL.setReplacement("" + amount)});
                } else if (target != sender) {
                    cmd.sendMessage(sender, GAVE_LEVEL, ChatColor.DARK_GREEN + "You have given " + ChatColor.GOLD + "{player} {level} levels", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.LEVEL.setReplacement("" + amount)});
                }
                if (target.isOnline()) {
                    cmd.sendMessage((CommandSender)target.getPlayer(), RECEIVED_LEVEL, ChatColor.DARK_GREEN + "You have received " + ChatColor.GOLD + "{level} levels " + ChatColor.DARK_GREEN + "from " + ChatColor.GOLD + "{player}", new CustomFilter[]{Filter.PLAYER.setReplacement(sender.getName()), RPGFilter.LEVEL.setReplacement("" + amount)});
                }
            }
        } else {
            CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
        }
    }
}

