/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cmd;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.language.RPGFilter;
import mc.promcteam.engine.mccore.commands.ConfigurableCommand;
import mc.promcteam.engine.mccore.commands.IFunction;
import mc.promcteam.engine.mccore.config.CustomFilter;
import mc.promcteam.engine.mccore.config.Filter;
import mc.promcteam.engine.mccore.util.TextFormatter;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CmdInfo
implements IFunction {
    private static final String NEEDS_ARGS = "needs-player";
    private static final String TITLE = "title";
    private static final String CATEGORY = "category";
    private static final String PROFESSION = "profession";
    private static final String EXP = "exp";
    private static final String SEPARATOR = "separator";
    private static final String END = "end";
    private static final String NO_CLASS = "no-class";
    private static final String NOT_PLAYER = "not-player";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args) {
        if (sender instanceof Player && !SkillAPI.getSettings().isWorldEnabled(((Player)sender).getWorld()) && args.length == 0) {
            cmd.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", new CustomFilter[0]);
        } else if (sender instanceof Player || args.length >= 1) {
            OfflinePlayer target;
            OfflinePlayer offlinePlayer = target = args.length == 0 ? (OfflinePlayer)sender : Bukkit.getOfflinePlayer((String)args[0]);
            if (target == null) {
                cmd.sendMessage(sender, NOT_PLAYER, ChatColor.RED + "That is not a valid player name", new CustomFilter[0]);
                return;
            }
            PlayerData data = SkillAPI.getPlayerData(target);
            cmd.sendMessage(sender, TITLE, ChatColor.DARK_GRAY + "--" + ChatColor.DARK_GREEN + " {player} " + ChatColor.DARK_GRAY + "-----------", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName())});
            String separator = cmd.getMessage(SEPARATOR, ChatColor.DARK_GRAY + "----------------------------", new CustomFilter[0]);
            boolean first = true;
            if (data != null) {
                for (String group : SkillAPI.getGroups()) {
                    PlayerClass c = data.getClass(group);
                    if (first) {
                        first = false;
                    } else {
                        sender.sendMessage(separator);
                    }
                    cmd.sendMessage(sender, CATEGORY, ChatColor.GOLD + "{group}" + ChatColor.GRAY + ": ", new CustomFilter[]{RPGFilter.GROUP.setReplacement(TextFormatter.format((String)group))});
                    PlayerClass profession = data.getClass(group);
                    if (profession == null) {
                        cmd.sendMessage(sender, NO_CLASS, ChatColor.GRAY + "Not Professed", new CustomFilter[0]);
                        continue;
                    }
                    cmd.sendMessage(sender, PROFESSION, ChatColor.AQUA + "Lv{level} " + ChatColor.DARK_GREEN + "{profession}", new CustomFilter[]{RPGFilter.LEVEL.setReplacement("" + profession.getLevel()), RPGFilter.PROFESSION.setReplacement(profession.getData().getName())});
                    cmd.sendMessage(sender, EXP, ChatColor.AQUA + "Exp " + ChatColor.DARK_GREEN + "{exp}", new CustomFilter[]{RPGFilter.EXP.setReplacement((int)profession.getExp() + "/" + profession.getRequiredExp())});
                }
            }
            cmd.sendMessage(sender, END, ChatColor.DARK_GRAY + "----------------------------", new CustomFilter[0]);
        } else {
            cmd.sendMessage(sender, NEEDS_ARGS, ChatColor.RED + "A player name is required from the console", new CustomFilter[0]);
        }
    }
}

