/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cmd;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.enums.PointSource;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.language.RPGFilter;
import mc.promcteam.engine.mccore.commands.CommandManager;
import mc.promcteam.engine.mccore.commands.ConfigurableCommand;
import mc.promcteam.engine.mccore.commands.IFunction;
import mc.promcteam.engine.mccore.config.CustomFilter;
import mc.promcteam.engine.mccore.config.Filter;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CmdForcePoints
implements IFunction {
    private static final String NOT_PLAYER = "not-player";
    private static final String NOT_GROUP = "not-group";
    private static final String NOT_NUMBER = "not-number";
    private static final String GAVE_SP = "gave-points";
    private static final String SET_SP = "set-points";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args) {
        Player target = null;
        Integer amount = null;
        String group = null;
        if (args.length == 2) {
            if (!(sender instanceof Player)) {
                cmd.sendMessage(sender, NOT_PLAYER, ChatColor.RED + "That is not a valid player name", new CustomFilter[0]);
                return;
            }
            target = (Player)sender;
            amount = Integer.parseInt(args[1]);
        } else if (args.length == 3) {
            target = Bukkit.getPlayer((String)args[1]);
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (target == null || amount == null) {
                if (!(sender instanceof Player)) {
                    CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
                    return;
                }
                target = (Player)sender;
                try {
                    amount = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
                    return;
                }
                group = args[2].toLowerCase();
                if (!SkillAPI.getGroups().contains(group)) {
                    CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
                    return;
                }
            }
        } else if (args.length == 4) {
            target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                cmd.sendMessage(sender, NOT_PLAYER, ChatColor.RED + "That is not a valid player name", new CustomFilter[0]);
                return;
            }
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException ignored) {
                cmd.sendMessage(sender, NOT_NUMBER, ChatColor.RED + "That is not a valid skill point amount", new CustomFilter[0]);
                return;
            }
            group = args[3].toLowerCase();
            if (!SkillAPI.getGroups().contains(group)) {
                cmd.sendMessage(sender, NOT_GROUP, ChatColor.RED + "That is not a valid class group", new CustomFilter[0]);
                return;
            }
        }
        if (!SkillAPI.getSettings().isWorldEnabled(target.getWorld())) {
            cmd.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", new CustomFilter[0]);
            return;
        }
        PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)target);
        if (data == null) {
            cmd.sendMessage(sender, NOT_PLAYER, ChatColor.RED + "That is not a valid player name", new CustomFilter[0]);
            return;
        }
        switch (args[0].toLowerCase()) {
            case "add": {
                if (group == null) {
                    data.givePoints((int)amount, PointSource.COMMAND);
                    cmd.sendMessage(sender, GAVE_SP, ChatColor.DARK_GREEN + "You have given " + ChatColor.GOLD + "{player} {points}{group} " + ChatColor.DARK_GREEN + "skill points", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.GROUP.setReplacement(""), RPGFilter.POINTS.setReplacement("" + amount)});
                    break;
                }
                PlayerClass clazz = data.getClass(group);
                if (clazz == null) {
                    cmd.sendMessage(sender, NOT_GROUP, ChatColor.RED + "That is not a valid class group", new CustomFilter[0]);
                    break;
                }
                clazz.givePoints(amount, PointSource.COMMAND);
                cmd.sendMessage(sender, GAVE_SP, ChatColor.DARK_GREEN + "You have given " + ChatColor.GOLD + "{player} {points}{group} " + ChatColor.DARK_GREEN + "skill points", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.GROUP.setReplacement(" " + group), RPGFilter.POINTS.setReplacement("" + amount)});
                break;
            }
            case "set": {
                if (group == null) {
                    data.setPoints(amount);
                    cmd.sendMessage(sender, SET_SP, ChatColor.DARK_GREEN + "You have set " + ChatColor.GOLD + "{player}'s{group} " + ChatColor.DARK_GREEN + "skill points to " + ChatColor.GOLD + "{points}", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.GROUP.setReplacement(""), RPGFilter.POINTS.setReplacement("" + amount)});
                    break;
                }
                PlayerClass clazz = data.getClass(group);
                if (clazz == null) {
                    cmd.sendMessage(sender, NOT_GROUP, ChatColor.RED + "That is not a valid class group", new CustomFilter[0]);
                    break;
                }
                clazz.setPoints(amount);
                cmd.sendMessage(sender, SET_SP, ChatColor.DARK_GREEN + "You have set " + ChatColor.GOLD + "{player}'s{group} " + ChatColor.DARK_GREEN + "skill points to " + ChatColor.GOLD + "{points}", new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.GROUP.setReplacement(" " + group), RPGFilter.POINTS.setReplacement("" + amount)});
                break;
            }
            default: {
                CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
            }
        }
    }
}

