/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.cmd;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.player.PlayerSkillBar;
import com.sucy.skill.api.util.BuffManager;
import com.sucy.skill.api.util.Combat;
import com.sucy.skill.api.util.FlagManager;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.hook.CitizensHook;
import com.sucy.skill.language.RPGFilter;
import mc.promcteam.engine.mccore.commands.ConfigurableCommand;
import mc.promcteam.engine.mccore.commands.IFunction;
import mc.promcteam.engine.mccore.config.CustomFilter;
import mc.promcteam.engine.mccore.config.Filter;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CmdChangeClass
implements IFunction {
    private static final String INVALID_GROUP = "invalid-group";
    private static final String INVALID_PLAYER = "invalid-player";
    private static final String INVALID_TARGET = "invalid-class";
    private static final String SUCCESS = "success";
    private static final String NOTIFICATION = "notification";

    public static void unload(Player player) {
        if (CitizensHook.isNPC((Entity)player)) {
            return;
        }
        PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)player);
        if (SkillAPI.getSettings().isWorldEnabled(player.getWorld())) {
            data.record(player);
            data.stopPassives(player);
        }
        FlagManager.clearFlags((LivingEntity)player);
        BuffManager.clearData((LivingEntity)player);
        Combat.clearData(player);
        DynamicSkill.clearCastData((LivingEntity)player);
        player.setDisplayName(player.getName());
        player.setWalkSpeed(0.2f);
    }

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args) {
        if (args.length >= 3) {
            boolean bar;
            String playerName = args[0];
            String groupName = args[1];
            Object className = args[2];
            for (int i = 3; i < args.length; ++i) {
                className = (String)className + " " + args[i];
            }
            Player player = Bukkit.getPlayer((String)playerName);
            if (player == null) {
                cmd.sendMessage(sender, INVALID_PLAYER, ChatColor.DARK_RED + "{player} is not online", new CustomFilter[]{Filter.PLAYER.setReplacement(playerName)});
                return;
            }
            PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)player);
            PlayerClass clazz = data.getClass(groupName);
            if (clazz == null) {
                cmd.sendMessage(sender, INVALID_GROUP, "{player} does not have a {class}", new CustomFilter[]{Filter.PLAYER.setReplacement(player.getName()), RPGFilter.GROUP.setReplacement(groupName), RPGFilter.CLASS.setReplacement((String)className)});
                return;
            }
            String original = clazz.getData().getName();
            RPGClass target = SkillAPI.getClass((String)className);
            if (target == null) {
                cmd.sendMessage(sender, INVALID_TARGET, "{class} is not a valid class to change to", new CustomFilter[]{RPGFilter.CLASS.setReplacement((String)className)});
                return;
            }
            boolean bl = bar = data.getSkillBar().isEnabled() && SkillAPI.getSettings().isSkillBarEnabled();
            if (bar) {
                PlayerSkillBar skillBar = data.getSkillBar();
                skillBar.toggleEnabled();
                skillBar.reset();
                data.getSkillBar().toggleEnabled();
            }
            clazz.setClassData(target);
            CmdChangeClass.unload(player);
            SkillAPI.getPlayerAccountData((OfflinePlayer)player).getActiveData().init(player);
            if (bar) {
                SkillAPI.getPlayerData((OfflinePlayer)player).getSkillBar().toggleEnabled();
            }
            cmd.sendMessage(sender, SUCCESS, "You have changed {player} from a {name} to a {class}", new CustomFilter[]{Filter.PLAYER.setReplacement(player.getName()), RPGFilter.GROUP.setReplacement(groupName), RPGFilter.CLASS.setReplacement((String)className), RPGFilter.NAME.setReplacement(original)});
            if (sender != player) {
                cmd.sendMessage((CommandSender)player, NOTIFICATION, "You have changed from a {name} to a {class}", new CustomFilter[]{RPGFilter.GROUP.setReplacement(groupName), RPGFilter.CLASS.setReplacement((String)className), RPGFilter.NAME.setReplacement(original)});
            }
        } else {
            cmd.displayHelp(sender);
        }
    }
}

