/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.util;

import com.sucy.skill.api.util.DamageLoreRemover;
import java.util.ArrayList;
import java.util.List;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import mc.promcteam.engine.mccore.util.TextFormatter;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class Data {
    private static final String MAT = "icon";
    private static final String DATA = "icon-data";
    private static final String DURABILITY = "icon-durability";
    private static final String LORE = "icon-lore";
    private static final String NAME = "name";

    private static ItemStack parse(String mat, int dur, int data, List<String> lore) {
        try {
            ItemStack item;
            ItemMeta meta;
            Material material = Material.matchMaterial((String)mat);
            if (material == null) {
                material = Material.JACK_O_LANTERN;
            }
            if ((meta = (item = new ItemStack(material)).getItemMeta()) != null) {
                if (data != 0) {
                    meta.setCustomModelData(Integer.valueOf(data));
                }
                if (lore != null && !lore.isEmpty()) {
                    List colored = TextFormatter.colorStringList(lore);
                    meta.setDisplayName((String)colored.remove(0));
                    meta.setLore(colored);
                }
                if (meta instanceof Damageable) {
                    ((Damageable)meta).setDamage(dur);
                }
                item.setItemMeta(meta);
            }
            return DamageLoreRemover.removeAttackDmg(item);
        }
        catch (Exception ex) {
            return new ItemStack(Material.JACK_O_LANTERN);
        }
    }

    public static void serializeIcon(ItemStack item, DataSection config) {
        config.set(MAT, (Object)item.getType().name());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            config.set(DATA, (Object)(meta.hasCustomModelData() ? meta.getCustomModelData() : 0));
            if (meta instanceof Damageable) {
                config.set(DURABILITY, (Object)((Damageable)meta).getDamage());
            } else {
                config.set(DURABILITY, (Object)0);
            }
            if (meta.hasDisplayName()) {
                ArrayList<String> lore = item.getItemMeta().getLore();
                if (lore == null) {
                    lore = new ArrayList<String>();
                }
                lore.add(0, item.getItemMeta().getDisplayName());
                int count = lore.size();
                for (int i = 0; i < count; ++i) {
                    lore.set(i, ((String)lore.get(i)).replace('\u00a7', '&').replaceAll("attr:(&.)+", "attr:"));
                }
                config.set(LORE, lore);
            }
        }
    }

    public static ItemStack parseIcon(DataSection config) {
        if (config == null) {
            return new ItemStack(Material.JACK_O_LANTERN);
        }
        int data = config.getInt(DATA, 0);
        return Data.parse(config.getString(MAT, "JACK_O_LANTERN"), config.getInt(DURABILITY, 0), data, config.getList(LORE, null));
    }
}

