/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.util;

import com.sucy.skill.api.util.Buff;
import com.sucy.skill.api.util.BuffData;
import com.sucy.skill.api.util.BuffType;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.LivingEntity;

public class BuffManager {
    private static final HashMap<UUID, BuffData> data = new HashMap();

    public static BuffData getBuffData(LivingEntity entity) {
        return BuffManager.getBuffData(entity, true);
    }

    public static BuffData getBuffData(LivingEntity entity, boolean create) {
        if (entity == null) {
            return null;
        }
        if (!data.containsKey(entity.getUniqueId()) && create) {
            data.put(entity.getUniqueId(), new BuffData(entity));
        }
        return data.get(entity.getUniqueId());
    }

    public static void clearData(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        BuffData result = data.remove(entity.getUniqueId());
        if (result != null) {
            result.clear();
        }
    }

    public static void addBuff(LivingEntity entity, BuffType type, Buff buff, int ticks) {
        if (entity == null) {
            return;
        }
        BuffManager.getBuffData(entity, true).addBuff(type, buff, ticks);
    }

    public static void addBuff(LivingEntity entity, BuffType type, String category, Buff buff, int ticks) {
        if (entity == null) {
            return;
        }
        BuffManager.getBuffData(entity, true).addBuff(type, category, buff, ticks);
    }

    @Deprecated
    public static void addDamageBuff(LivingEntity entity, Buff buff, int ticks) {
        BuffManager.addBuff(entity, BuffType.DAMAGE, buff, ticks);
    }

    @Deprecated
    public static void addDefenseBuff(LivingEntity entity, Buff buff, int ticks) {
        BuffManager.addBuff(entity, BuffType.DEFENSE, buff, ticks);
    }

    @Deprecated
    public static void addSkillDamageBuff(LivingEntity entity, Buff buff, int ticks) {
        BuffManager.addBuff(entity, BuffType.SKILL_DAMAGE, buff, ticks);
    }

    @Deprecated
    public static void addSkillDefenseBuff(LivingEntity entity, Buff buff, int ticks) {
        BuffManager.addBuff(entity, BuffType.SKILL_DEFENSE, buff, ticks);
    }

    public static double apply(LivingEntity entity, BuffType type, double amount) {
        BuffData data = BuffManager.getBuffData(entity, false);
        return data == null ? amount : data.apply(type, amount);
    }

    public static double apply(LivingEntity entity, BuffType type, String category, double amount) {
        BuffData data = BuffManager.getBuffData(entity, false);
        return data == null ? amount : data.apply(type, category, amount);
    }

    @Deprecated
    public static double modifyDealtDamage(LivingEntity entity, double damage) {
        return BuffManager.apply(entity, BuffType.DAMAGE, damage);
    }

    @Deprecated
    public static double modifyTakenDefense(LivingEntity entity, double damage) {
        return BuffManager.apply(entity, BuffType.DEFENSE, damage);
    }

    @Deprecated
    public static double modifySkillDealtDamage(LivingEntity entity, double damage) {
        return BuffManager.apply(entity, BuffType.SKILL_DAMAGE, damage);
    }

    @Deprecated
    public static double modifySkillTakenDefense(LivingEntity entity, double damage) {
        return BuffManager.apply(entity, BuffType.SKILL_DEFENSE, damage);
    }
}

