/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.util;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.event.BuffExpiredEvent;
import com.sucy.skill.api.util.Buff;
import com.sucy.skill.api.util.BuffManager;
import com.sucy.skill.api.util.BuffType;
import com.sucy.skill.log.LogType;
import com.sucy.skill.log.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.scheduler.BukkitRunnable;

public class BuffData {
    private final Map<String, Map<String, Buff>> buffs = new HashMap<String, Map<String, Buff>>();
    private LivingEntity entity;

    public BuffData(LivingEntity entity) {
        this.entity = entity;
    }

    public double getMultiplier(BuffType buffType, String category) {
        return category == null || category.isEmpty() ? this.getMultiplier(buffType.name()) : this.getMultiplier(buffType.name(), buffType.name() + category);
    }

    public double getFlatBonus(BuffType buffType, String category) {
        return category == null || category.isEmpty() ? this.getFlatBonus(buffType.name()) : this.getFlatBonus(buffType.name(), buffType.name() + category);
    }

    public void addBuff(BuffType type, Buff buff, int ticks) {
        this.doAddBuff(type.name(), buff, ticks);
    }

    public void addBuff(BuffType type, String category, Buff buff, int ticks) {
        this.doAddBuff(type.name() + (category != null ? category : ""), buff, ticks);
    }

    private void doAddBuff(String type, Buff buff, int ticks) {
        Map typeBuffs = this.buffs.computeIfAbsent(type, t -> new HashMap());
        Buff conflict = (Buff)typeBuffs.remove(buff.getKey());
        if (conflict != null) {
            conflict.task.cancel();
        }
        typeBuffs.put(buff.getKey(), buff);
        buff.task = SkillAPI.schedule(new BuffTask(type, buff.getKey()), ticks);
    }

    @Deprecated
    public void addDamageBuff(Buff buff, int ticks) {
        this.addBuff(BuffType.DAMAGE, buff, ticks);
    }

    @Deprecated
    public void addDefenseBuff(Buff buff, int ticks) {
        this.addBuff(BuffType.DEFENSE, buff, ticks);
    }

    @Deprecated
    public void addSkillDamageBuff(Buff buff, int ticks) {
        this.addBuff(BuffType.SKILL_DAMAGE, buff, ticks);
    }

    @Deprecated
    public void addSkillDefenseBuff(Buff buff, int ticks) {
        this.addBuff(BuffType.SKILL_DEFENSE, buff, ticks);
    }

    public double apply(BuffType type, double value) {
        return this.doApply(value, type.name());
    }

    public boolean isActive(BuffType type) {
        Map<String, Buff> typeBuffs = this.buffs.get(type.name());
        return typeBuffs != null;
    }

    public void clearByType(BuffType type) {
        Map<String, Buff> buffType = this.buffs.get(type.name());
        if (buffType == null) {
            return;
        }
        for (Buff buff : buffType.values()) {
            buff.task.cancel();
        }
        this.buffs.remove(type.name());
    }

    public double apply(BuffType type, String category, double value) {
        return category == null || category.length() == 0 ? this.doApply(value, type.name()) : this.doApply(value, type.name(), type.name() + category);
    }

    private double doApply(double value, String ... types) {
        if (value <= 0.0) {
            return value;
        }
        double multiplier = 1.0;
        double bonus = 0.0;
        Logger.log(LogType.BUFF, 1, "Buffs:");
        for (String type : types) {
            Map<String, Buff> typeBuffs = this.buffs.get(type);
            if (typeBuffs == null) continue;
            for (Buff buff : typeBuffs.values()) {
                if (buff.isPercent()) {
                    Logger.log(LogType.BUFF, 1, "  - x" + buff.getValue());
                    multiplier *= buff.getValue();
                    continue;
                }
                Logger.log(LogType.BUFF, 1, "  - +" + buff.getValue());
                bonus += buff.getValue();
            }
        }
        double result = Math.max(0.0, value * multiplier + bonus);
        Logger.log(LogType.BUFF, 1, "Result: x" + multiplier + ", +" + bonus + ", " + value + " -> " + result);
        if (multiplier <= 0.0) {
            return 0.0;
        }
        return result;
    }

    private double getFlatBonus(String ... types) {
        double bonus = 0.0;
        for (String type : types) {
            for (Buff buff : this.buffs.getOrDefault(type, Collections.emptyMap()).values()) {
                if (buff.isPercent()) continue;
                bonus += buff.getValue();
            }
        }
        return bonus;
    }

    private double getMultiplier(String ... types) {
        double multiplier = 1.0;
        for (String type : types) {
            for (Buff buff : this.buffs.getOrDefault(type, Collections.emptyMap()).values()) {
                if (!buff.isPercent()) continue;
                multiplier *= buff.getValue();
            }
        }
        return Math.max(0.0, multiplier);
    }

    @Deprecated
    public double modifyDealtDamage(double damage) {
        return this.apply(BuffType.DAMAGE, damage);
    }

    @Deprecated
    public double modifyTakenDamage(double damage) {
        return this.apply(BuffType.DEFENSE, damage);
    }

    @Deprecated
    public double modifySkillDealtDamage(double damage) {
        return this.apply(BuffType.SKILL_DAMAGE, damage);
    }

    @Deprecated
    public double modifySkillTakenDamage(double damage) {
        return this.apply(BuffType.SKILL_DEFENSE, damage);
    }

    public void clear() {
        for (Map<String, Buff> typeBuffs : this.buffs.values()) {
            for (Buff buff : typeBuffs.values()) {
                buff.task.cancel();
            }
        }
        this.buffs.clear();
        BuffManager.clearData(this.entity);
    }

    private class BuffTask
    extends BukkitRunnable {
        private final String type;
        private final String key;

        BuffTask(String type, String key) {
            this.type = type;
            this.key = key;
        }

        public void run() {
            if (!BuffData.this.entity.isValid() || BuffData.this.entity.isDead()) {
                BuffManager.clearData(BuffData.this.entity);
                return;
            }
            Map<String, Buff> typeBuffs = BuffData.this.buffs.get(this.type);
            typeBuffs.remove(this.key);
            if (typeBuffs.size() == 0) {
                BuffData.this.buffs.remove(this.type);
                if (BuffData.this.buffs.size() == 0) {
                    BuffManager.clearData(BuffData.this.entity);
                }
            }
            BuffExpiredEvent event = new BuffExpiredEvent(BuffData.this.entity, typeBuffs.get(this.type), BuffType.valueOf(this.type));
            Bukkit.getPluginManager().callEvent((Event)event);
        }
    }
}

