/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.projectile;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.Settings;
import com.sucy.skill.api.particle.target.Followable;
import com.sucy.skill.api.projectile.ProjectileCallback;
import com.sucy.skill.log.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import mc.promcteam.engine.utils.Reflex;
import mc.promcteam.engine.utils.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public abstract class CustomProjectile
extends BukkitRunnable
implements Metadatable,
Followable {
    private static final Vector X_VEC = new Vector(1, 0, 0);
    private static final double DEGREE_TO_RAD = Math.PI / 180;
    private static final Vector vel = new Vector();
    private static Constructor<?> aabbConstructor;
    private static Method getEntities;
    private static Method getBukkitEntity;
    private static final Predicate<Object> JAVA_PREDICATE;
    private static final com.google.common.base.Predicate<Object> GUAVA_PREDICATE;
    private static Method getEntitiesGuava;
    private static Method getHandle;
    private final HashMap<String, List<MetadataValue>> metadata = new HashMap();
    private final Set<Integer> hit = new HashSet<Integer>();
    private final LivingEntity thrower;
    protected ProjectileCallback callback;
    protected final Settings settings;
    protected boolean enemy = true;
    protected boolean ally = false;
    private boolean valid = true;

    public CustomProjectile(LivingEntity thrower, Settings settings) {
        this.thrower = thrower;
        this.settings = settings;
        this.runTaskTimer((Plugin)SkillAPI.inst(), 1L, 1L);
    }

    private static boolean isLivingEntity(Object thing) {
        try {
            return getBukkitEntity.invoke(thing, new Object[0]) instanceof LivingEntity;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static ArrayList<Vector> calcSpread(Vector dir, double angle, int amount) {
        if (amount <= 0) {
            return new ArrayList<Vector>();
        }
        ArrayList<Vector> list = new ArrayList<Vector>();
        if (amount % 2 == 1) {
            list.add(dir);
            --amount;
        }
        if (amount <= 0) {
            return list;
        }
        Vector base = dir.clone();
        base.setY(0);
        base.normalize();
        vel.setX(1);
        vel.setY(0);
        vel.setZ(0);
        double vBaseAngle = Math.acos(Math.max(-1.0, Math.min(base.dot(dir), 1.0)));
        if (dir.getY() < 0.0) {
            vBaseAngle = -vBaseAngle;
        }
        double hAngle = Math.acos(Math.max(-1.0, Math.min(1.0, base.dot(X_VEC)))) / (Math.PI / 180);
        if (dir.getZ() < 0.0) {
            hAngle = -hAngle;
        }
        double angleIncrement = angle / (double)(amount - 1);
        for (int i = 0; i < amount / 2; ++i) {
            for (int direction = -1; direction <= 1; direction += 2) {
                double bonusAngle = angle / 2.0 * (double)direction - angleIncrement * (double)i * (double)direction;
                double totalAngle = hAngle + bonusAngle;
                double vAngle = vBaseAngle * Math.cos(bonusAngle * (Math.PI / 180));
                double x = Math.cos(vAngle);
                vel.setX(x * Math.cos(totalAngle * (Math.PI / 180)));
                vel.setY(Math.sin(vAngle));
                vel.setZ(x * Math.sin(totalAngle * (Math.PI / 180)));
                list.add(vel.clone());
            }
        }
        return list;
    }

    public static ArrayList<Location> calcRain(Location loc, double radius, double height, int amount) {
        ArrayList<Location> list = new ArrayList<Location>();
        if (amount <= 0) {
            return list;
        }
        loc.add(0.0, height, 0.0);
        list.add(loc);
        int tiers = (--amount + 7) / 8;
        for (int i = 0; i < tiers; ++i) {
            double rad = radius * (double)(tiers - i) / (double)tiers;
            int tierNum = Math.min(amount, 8);
            double increment = 360 / tierNum;
            double angle = (double)(i % 2) * 22.5;
            for (int j = 0; j < tierNum; ++j) {
                double dx = Math.cos(angle) * rad;
                double dz = Math.sin(angle) * rad;
                Location l = loc.clone();
                l.add(dx, 0.0, dz);
                list.add(l);
                angle += increment;
            }
            amount -= tierNum;
        }
        return list;
    }

    @Override
    public abstract Location getLocation();

    @Override
    public boolean isValid() {
        return this.valid;
    }

    protected abstract Event expire();

    protected abstract Event land();

    protected abstract Event hit(LivingEntity var1);

    protected abstract boolean landed();

    protected abstract double getCollisionRadius();

    protected abstract Vector getVelocity();

    protected abstract void setVelocity(Vector var1);

    protected boolean isTraveling() {
        if (!this.getLocation().getChunk().isLoaded()) {
            this.cancel();
            Bukkit.getPluginManager().callEvent(this.expire());
            return false;
        }
        if (this.landed()) {
            this.applyLanded();
            return false;
        }
        return true;
    }

    public void applyLanded() {
        if (this.valid) {
            this.cancel();
            Bukkit.getPluginManager().callEvent(this.land());
            if (this.callback != null) {
                this.callback.callback(this, null);
            }
        }
    }

    protected boolean checkCollision(boolean pierce) {
        for (LivingEntity entity : this.getColliding()) {
            if (entity == this.thrower || this.hit.contains(entity.getEntityId())) continue;
            this.hit.add(entity.getEntityId());
            boolean ally = SkillAPI.getSettings().isAlly(this.getShooter(), entity);
            if (ally && !this.ally || !ally && !this.enemy || !SkillAPI.getSettings().isValidTarget(entity)) continue;
            Bukkit.getPluginManager().callEvent(this.hit(entity));
            if (this.callback != null) {
                this.callback.callback(this, entity);
            }
            if (pierce) continue;
            this.cancel();
            return false;
        }
        return true;
    }

    private List<LivingEntity> getColliding() {
        ArrayList<LivingEntity> result = new ArrayList<LivingEntity>(1);
        try {
            Object nmsWorld = getHandle.invoke((Object)this.getLocation().getWorld(), new Object[0]);
            Object predicate = getEntities == null ? GUAVA_PREDICATE : JAVA_PREDICATE;
            Object list = (getEntities == null ? getEntitiesGuava : getEntities).invoke(nmsWorld, null, this.getBoundingBox(), predicate);
            for (Object item : (List)list) {
                result.add((LivingEntity)getBukkitEntity.invoke(item, new Object[0]));
            }
        }
        catch (Exception ex) {
            double radiusSq = this.getCollisionRadius();
            radiusSq *= radiusSq;
            for (LivingEntity entity : this.getNearbyEntities()) {
                if (entity == this.thrower || !(this.getLocation().distanceSquared(entity.getLocation()) < radiusSq)) continue;
                result.add(entity);
            }
        }
        return result;
    }

    private Object getBoundingBox() throws Exception {
        Location loc = this.getLocation();
        double rad = this.getCollisionRadius();
        return aabbConstructor.newInstance(loc.getX() - rad, loc.getY() - rad, loc.getZ() - rad, loc.getX() + rad, loc.getY() + rad, loc.getZ() + rad);
    }

    private List<LivingEntity> getNearbyEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        Location loc = this.getLocation();
        double radius = this.getCollisionRadius();
        int minX = (int)(loc.getX() - radius) >> 4;
        int maxX = (int)(loc.getX() + radius) >> 4;
        int minZ = (int)(loc.getZ() - radius) >> 4;
        int maxZ = (int)(loc.getZ() + radius) >> 4;
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minZ; j < maxZ; ++j) {
                for (Entity entity : loc.getWorld().getChunkAt(i, j).getEntities()) {
                    if (!(entity instanceof LivingEntity)) continue;
                    list.add((LivingEntity)entity);
                }
            }
        }
        return list;
    }

    public void setAllyEnemy(boolean ally, boolean enemy) {
        this.ally = ally;
        this.enemy = enemy;
    }

    public LivingEntity getShooter() {
        return this.thrower;
    }

    public void cancel() {
        super.cancel();
        this.valid = false;
    }

    public void setMetadata(String key, MetadataValue meta) {
        boolean hasMeta = this.hasMetadata(key);
        List<Object> list = hasMeta ? this.getMetadata(key) : new ArrayList();
        list.add(meta);
        if (!hasMeta) {
            this.metadata.put(key, list);
        }
    }

    public List<MetadataValue> getMetadata(String key) {
        return this.metadata.get(key);
    }

    public boolean hasMetadata(String key) {
        return this.metadata.containsKey(key);
    }

    public void removeMetadata(String key, Plugin plugin) {
        this.metadata.remove(key);
    }

    public void setCallback(ProjectileCallback callback) {
        this.callback = callback;
    }

    static {
        JAVA_PREDICATE = CustomProjectile::isLivingEntity;
        GUAVA_PREDICATE = CustomProjectile::isLivingEntity;
        try {
            Class aabbClass = ReflectionManager.MINOR_VERSION >= 17 ? Reflex.getClass((String)"net.minecraft.world.phys.AxisAlignedBB") : Reflex.getNMSClass((String)"AxisAlignedBB");
            Class entityClass = ReflectionManager.MINOR_VERSION >= 17 ? Reflex.getClass((String)"net.minecraft.world.entity.Entity") : Reflex.getNMSClass((String)"Entity");
            aabbConstructor = aabbClass.getConstructor(Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            getBukkitEntity = entityClass.getDeclaredMethod("getBukkitEntity", new Class[0]);
            getHandle = Reflex.getCraftClass((String)"CraftWorld").getDeclaredMethod("getHandle", new Class[0]);
            Class worldClass = ReflectionManager.MINOR_VERSION >= 17 ? Reflex.getClass((String)"net.minecraft.world.level.World") : Reflex.getNMSClass((String)"World");
            try {
                getEntities = worldClass.getDeclaredMethod(ReflectionManager.MINOR_VERSION >= 18 ? "a" : "getEntities", entityClass, aabbClass, Predicate.class);
            }
            catch (Exception e) {
                getEntitiesGuava = worldClass.getDeclaredMethod(ReflectionManager.MINOR_VERSION >= 18 ? "a" : "getEntities", entityClass, aabbClass, com.google.common.base.Predicate.class);
            }
        }
        catch (Exception ex) {
            Logger.log("Unable to use reflection for accurate collision - will resort to simple radius check");
            ex.printStackTrace();
        }
    }
}

