/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.particle;

import com.sucy.skill.api.Settings;
import com.sucy.skill.api.particle.EffectInstance;
import com.sucy.skill.api.particle.EffectManager;
import com.sucy.skill.api.particle.ParticleEffect;
import com.sucy.skill.api.particle.ParticleHelper;
import com.sucy.skill.api.particle.ParticleSettings;
import com.sucy.skill.api.particle.direction.Directions;
import com.sucy.skill.api.particle.target.EffectTarget;
import com.sucy.skill.log.Logger;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;

public class EffectPlayer {
    public static final String SHAPE = "-shape";
    public static final String SHAPE_DIR = "-shape-dir";
    public static final String SHAPE_SIZE = "-shape-size";
    public static final String ANIMATION = "-animation";
    public static final String ANIM_DIR = "-anim-dir";
    public static final String ANIM_SIZE = "-anim-size";
    public static final String INTERVAL = "-interval";
    public static final String VIEW_RANGE = "-view-range";
    public static final String WITH_ROTATION = "-with-rotation";
    public static final String INITIAL_ROTATION = "-initial-rotation";
    public static final String P_TYPE = "-particle-type";
    public static final String MAT = "-particle-material";
    public static final String DURABILITY = "-particle-durability";
    public static final String CMD = "-particle-data";
    public static final String DUST_COLOR = "-particle-dust-color";
    public static final String FINAL_DUST_COLOR = "-particle-final-dust-color";
    public static final String DUST_SIZE = "-particle-dust-size";
    public static final String AMOUNT = "-particle-amount";
    public static final String DX = "-particle-dx";
    public static final String DY = "-particle-dy";
    public static final String DZ = "-particle-dz";
    public static final String SPEED = "-particle-speed";
    private final Settings settings;

    public EffectPlayer(Settings settings) {
        this.settings = settings;
    }

    public void start(EffectTarget target, String key, int ticks, int level) {
        this.start(target, key, ticks, level, false);
    }

    public void start(EffectTarget target, String key, int ticks, int level, boolean noPrefix) {
        EffectInstance instance = EffectManager.getEffect(target, key);
        if (instance != null) {
            instance.extend(ticks);
            return;
        }
        if (EffectManager.getEffect(key) == null) {
            this.makeEffect(key, noPrefix);
        }
        EffectManager.runEffect(EffectManager.getEffect(key), target, ticks, level);
    }

    private void makeEffect(String key, boolean noPrefix) {
        ParticleSettings particle;
        String keyMod = noPrefix ? "" : key;
        Particle particleType = ParticleHelper.getFromKey(this.settings.getString(keyMod + P_TYPE, "Villager happy"));
        try {
            particle = new ParticleSettings(particleType, (float)this.settings.getDouble(keyMod + DX), (float)this.settings.getDouble(keyMod + DY), (float)this.settings.getDouble(keyMod + DZ), (float)this.settings.getDouble(keyMod + SPEED, 1.0), this.settings.getInt(keyMod + AMOUNT, 1), Material.matchMaterial((String)this.settings.getString(keyMod + MAT, "DIRT")), this.settings.getInt(keyMod + CMD, 0), this.settings.getInt(keyMod + DURABILITY, 0), Color.fromRGB((int)Integer.parseInt(this.settings.getString(DUST_COLOR, "#FF0000").substring(1), 16)), Color.fromRGB((int)Integer.parseInt(this.settings.getString(FINAL_DUST_COLOR, "#FF0000").substring(1), 16)), (float)this.settings.getDouble(DUST_SIZE, 1.0));
        }
        catch (Exception ex) {
            Logger.invalid("Bad material for particle effect - " + this.settings.getString(keyMod + MAT));
            return;
        }
        ParticleEffect effect = new ParticleEffect(key, EffectManager.getFormula(this.settings.getString(keyMod + SHAPE, "single")), EffectManager.getFormula(this.settings.getString(keyMod + ANIMATION, "single")), particle, Directions.byName(this.settings.getString(keyMod + SHAPE_DIR, "XZ")), Directions.byName(this.settings.getString(keyMod + ANIM_DIR, "XZ")), this.settings.getString(keyMod + SHAPE_SIZE, "1"), this.settings.getString(keyMod + ANIM_SIZE, "1"), this.settings.getInt(keyMod + INTERVAL, 1), this.settings.getInt(keyMod + VIEW_RANGE, 25), this.settings.getBool(keyMod + WITH_ROTATION, true), this.settings.getDouble(keyMod + INITIAL_ROTATION, 0.0));
        EffectManager.register(effect);
    }
}

