/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.event;

import com.sucy.skill.dynamic.TempEntity;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

public class PlayerBlockDamageEvent
extends PlayerEvent {
    private static final HandlerList handlers = new HandlerList();
    private Entity source;
    private double damage;
    private String type = "melee";

    public PlayerBlockDamageEvent(Entity damager, PlayerStatisticIncrementEvent statEvent) {
        super(statEvent.getPlayer());
        this.source = damager;
        if (this.source instanceof Projectile) {
            this.type = "projectile";
            ProjectileSource ps = ((Projectile)this.source).getShooter();
            if (ps instanceof BlockProjectileSource) {
                Location locTarget = ((BlockProjectileSource)ps).getBlock().getLocation();
                this.source = new TempEntity(locTarget);
            } else {
                this.source = (Entity)ps;
            }
        }
        this.damage = (double)(statEvent.getNewValue() - statEvent.getPreviousValue()) / 10.0;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public Entity getSource() {
        return this.source;
    }

    public double getDamage() {
        return this.damage;
    }

    public String getType() {
        return this.type;
    }
}

