/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.api.armorstand;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.armorstand.ArmorStandData;
import com.sucy.skill.api.armorstand.ArmorStandInstance;
import com.sucy.skill.task.ArmorStandTask;
import com.sucy.skill.thread.MainThread;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.metadata.Metadatable;

public class ArmorStandManager {
    private static final Map<LivingEntity, ArmorStandData> instances = new ConcurrentHashMap<LivingEntity, ArmorStandData>();

    public static void init() {
        MainThread.register(new ArmorStandTask());
        Bukkit.getWorlds().forEach(world -> world.getEntitiesByClass(ArmorStand.class).forEach(as -> {
            if (SkillAPI.getMeta((Metadatable)as, "asMechanic") != null) {
                as.remove();
            }
        }));
    }

    public static void cleanUp() {
        instances.values().forEach(ArmorStandData::remove);
        instances.clear();
    }

    public static void clear(LivingEntity target) {
        instances.remove(target);
    }

    public static ArmorStandData getArmorStandData(LivingEntity target) {
        return instances.get(target);
    }

    public static ArmorStandInstance getArmorStand(LivingEntity target, String key) {
        if (!instances.containsKey(target)) {
            return null;
        }
        return instances.get(target).getArmorStands(key);
    }

    public static void register(ArmorStandInstance armorStand, LivingEntity target, String key) {
        if (!instances.containsKey(target)) {
            instances.put(target, new ArmorStandData(target));
        }
        instances.get(target).register(armorStand, key);
    }

    public static void tick() {
        Iterator<ArmorStandData> iterator = instances.values().iterator();
        while (iterator.hasNext()) {
            ArmorStandData data = iterator.next();
            if (data.isValid()) {
                data.tick();
                continue;
            }
            data.remove();
            iterator.remove();
        }
    }
}

