/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.tree.basic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.exception.SkillTreeException;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.gui.tool.GUIType;
import com.sucy.skill.tree.basic.InventoryTree;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public abstract class LevelTree
extends InventoryTree {
    private static final Comparator<Skill> levelComparator = new Comparator<Skill>(){

        @Override
        public int compare(Skill skill1, Skill skill2) {
            return skill1.getLevelReq(0) > skill2.getLevelReq(0) ? 1 : (skill1.getLevelReq(0) < skill2.getLevelReq(0) ? -1 : (skill1.getCost(0) > skill2.getCost(0) ? 1 : (skill1.getCost(0) < skill2.getCost(0) ? -1 : skill1.getName().compareTo(skill2.getName()))));
        }
    };

    public LevelTree(SkillAPI api, RPGClass tree) {
        super(api, tree);
    }

    @Override
    protected void arrange(List<Skill> skills) throws SkillTreeException {
        this.skillSlots.clear();
        int maxLevel = 1;
        for (Skill skill : skills) {
            if (skill.getLevelReq(0) <= maxLevel) continue;
            maxLevel = skill.getLevelReq(0);
        }
        int scale = this.getTierLimit() > 0 ? (maxLevel + this.getTierLimit() - 1) / this.getTierLimit() : 1;
        skills.sort(levelComparator);
        HashMap tiers = new HashMap();
        int tier = 0;
        while (skills.size() > 0) {
            ArrayList<Skill> list = new ArrayList<Skill>();
            tiers.put(tier++, list);
            int max = tier * scale;
            int count = 0;
            while (skills.size() > 0 && (this.getPerTierLimit() < 0 || count++ < this.getPerTierLimit()) && skills.get(0).getLevelReq(0) <= max) {
                list.add(skills.remove(0));
            }
        }
        for (int i = 0; i < tier; ++i) {
            List list = (List)tiers.get(i);
            int maxIndex = 0;
            for (int k = 0; k < i; ++k) {
                List prevList = (List)tiers.get(k);
                for (int j = 0; j < prevList.size(); ++j) {
                    Skill prevSkill = (Skill)prevList.get(j);
                    for (int l = 0; l < list.size(); ++l) {
                        Skill nextSkill = (Skill)list.get(l);
                        if (nextSkill.getSkillReq() == null || !nextSkill.getSkillReq().equalsIgnoreCase(prevSkill.getName())) continue;
                        list.remove(l);
                        int index = Math.min(Math.max(maxIndex, j), list.size());
                        maxIndex = Math.max(maxIndex + 1, j);
                        list.add(index, nextSkill);
                    }
                }
            }
            for (int j = 0; j < list.size(); ++j) {
                int index = this.getPerTierLimit() == 8 ? j + i * 9 : j * 9 + i;
                this.skillSlots.put(index, (Skill)list.get(j));
                if (index / 9 + 1 <= this.height) continue;
                this.height = index / 9 + 1;
            }
        }
        this.height = Math.max(1, Math.min(SkillAPI.getConfig("gui").getConfig().getInt(GUIType.SKILL_TREE.getPrefix() + this.tree.getName() + ".rows", this.height), 6));
    }

    protected abstract int getPerTierLimit();

    protected abstract int getTierLimit();
}

