/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.tree.basic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.exception.SkillTreeException;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.gui.tool.GUIType;
import com.sucy.skill.tree.basic.InventoryTree;
import java.util.List;
import mc.promcteam.engine.mccore.config.parse.DataSection;

public class CustomTree
extends InventoryTree {
    public CustomTree(SkillAPI api, RPGClass tree) {
        super(api, tree);
    }

    @Override
    protected void arrange(List<Skill> skills) throws SkillTreeException {
        this.skillSlots.clear();
        this.height = 3;
        DataSection section = SkillAPI.getConfig("gui").getConfig().getSection(GUIType.SKILL_TREE.getPrefix() + this.tree.getName());
        if (section == null) {
            return;
        }
        this.height = Math.max(1, Math.min(section.getInt("rows", 3), 6));
        DataSection slotsSection = section.getSection("slots");
        if (slotsSection == null) {
            return;
        }
        for (String key : slotsSection.keys()) {
            int page = Integer.parseInt(key);
            DataSection pageSection = slotsSection.getSection(key);
            for (String skillName : pageSection.keys()) {
                Skill skill = SkillAPI.getSkill(skillName);
                if (skill == null) continue;
                this.skillSlots.put(pageSection.getInt(skillName) + (page - 1) * this.height * 9, skill);
            }
        }
    }
}

