/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.task;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.event.ProjectileTickEvent;
import com.sucy.skill.dynamic.ComponentRegistry;
import com.sucy.skill.dynamic.trigger.ProjectileTickTrigger;
import com.sucy.skill.listener.ProjectileListener;
import com.sucy.skill.thread.RepeatThreadTask;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class ProjectileTickTask
extends RepeatThreadTask {
    private final LivingEntity shooter;
    private final Projectile projectile;
    private int tick;

    public ProjectileTickTask(LivingEntity shooter, Projectile projectile) {
        super(0, 1);
        this.shooter = shooter;
        this.projectile = projectile;
        this.expired = false;
        this.tick = 1;
    }

    @Override
    public void run() {
        boolean bl = this.expired = !ProjectileListener.isFlying(this.projectile);
        if (!this.expired) {
            ProjectileTickEvent event = new ProjectileTickEvent(this.shooter, this.projectile, this.tick);
            Bukkit.getScheduler().runTask((Plugin)SkillAPI.inst(), () -> Bukkit.getPluginManager().callEvent((Event)event));
            ++this.tick;
        } else {
            ((ProjectileTickTrigger)ComponentRegistry.getTrigger("PROJECTILE_TICK")).removeProjectile(this.projectile.getUniqueId());
        }
    }
}

