/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.manager;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.util.DamageLoreRemover;
import com.sucy.skill.api.util.Data;
import com.sucy.skill.data.formula.Formula;
import com.sucy.skill.data.formula.value.CustomValue;
import com.sucy.skill.dynamic.ComponentType;
import com.sucy.skill.dynamic.EffectComponent;
import com.sucy.skill.gui.tool.GUIData;
import com.sucy.skill.gui.tool.GUIPage;
import com.sucy.skill.gui.tool.GUITool;
import com.sucy.skill.gui.tool.IconHolder;
import com.sucy.skill.log.LogType;
import com.sucy.skill.log.Logger;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mc.promcteam.engine.mccore.config.CommentedConfig;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

public class AttributeManager {
    public static final String HEALTH = "health";
    public static final String MANA = "mana";
    public static final String MANA_REGEN = "mana-regen";
    public static final String PHYSICAL_DAMAGE = "physical-damage";
    public static final String MELEE_DAMAGE = "melee-damage";
    public static final String PROJECTILE_DAMAGE = "projectile-damage";
    public static final String PHYSICAL_DEFENSE = "physical-defense";
    public static final String MELEE_DEFENSE = "melee-defense";
    public static final String PROJECTILE_DEFENSE = "projectile-defense";
    public static final String SKILL_DAMAGE = "skill-damage";
    public static final String SKILL_DEFENSE = "skill-defense";
    public static final String MOVE_SPEED = "move-speed";
    public static final String ATTACK_SPEED = "attack-speed";
    public static final String ARMOR = "armor";
    public static final String LUCK = "luck";
    public static final String ARMOR_TOUGHNESS = "armor-toughness";
    public static final String EXPERIENCE = "exp";
    public static final String HUNGER = "hunger";
    public static final String HUNGER_HEAL = "hunger-heal";
    public static final String COOLDOWN = "cooldown";
    public static final String KNOCKBACK_RESIST = "knockback-resist";
    private final HashMap<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();
    private final HashMap<String, Attribute> lookup = new HashMap();
    private final HashMap<String, List<Attribute>> byStat = new HashMap();
    private final HashMap<String, List<Attribute>> byComponent = new HashMap();

    public AttributeManager(SkillAPI api) {
        this.load(api);
    }

    public Attribute getAttribute(String key) {
        return this.lookup.get(key.toLowerCase());
    }

    public HashMap<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public List<Attribute> forStat(String key) {
        return this.byStat.get(key.toLowerCase());
    }

    public List<Attribute> forComponent(EffectComponent component, String key) {
        return this.byComponent.get(component.getKey() + "-" + key.toLowerCase());
    }

    public Set<String> getKeys() {
        return this.attributes.keySet();
    }

    public Set<String> getLookupKeys() {
        return this.lookup.keySet();
    }

    public String normalize(String key) {
        Attribute attribute = this.lookup.get(key.toLowerCase());
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute - " + key);
        }
        return attribute.getKey();
    }

    private void load(SkillAPI api) {
        CommentedConfig config = new CommentedConfig((JavaPlugin)api, "attributes");
        config.saveDefaultConfig();
        DataSection data = config.getConfig();
        Logger.log(LogType.ATTRIBUTE_LOAD, 1, "Loading attributes...");
        for (String key : data.keys()) {
            Logger.log(LogType.ATTRIBUTE_LOAD, 2, "  - " + key);
            Attribute attribute = new Attribute(data.getSection(key), key);
            this.attributes.put(attribute.getKey(), attribute);
            this.lookup.put(attribute.getKey(), attribute);
            this.lookup.put(attribute.getName().toLowerCase(), attribute);
        }
        GUIData attribs = GUITool.getAttributesMenu();
        if (!attribs.isValid()) {
            int i = 0;
            GUIPage page = attribs.getPage(0);
            for (String key : this.attributes.keySet()) {
                if (i >= 54) continue;
                page.set(i++, key);
            }
            attribs.resize((this.attributes.size() + 8) / 9);
        }
    }

    public class Attribute
    implements IconHolder {
        private static final String DISPLAY = "display";
        private static final String GLOBAL = "global";
        private static final String CONDITION = "condition";
        private static final String MECHANIC = "mechanic";
        private static final String TARGET = "target";
        private static final String STATS = "stats";
        private static final String MAX = "max";
        private String key;
        private String display;
        private ItemStack icon;
        private int max;
        private Map<ComponentType, Map<String, AttributeValue[]>> dynamicModifiers = new EnumMap<ComponentType, Map<String, AttributeValue[]>>(ComponentType.class);
        private HashMap<String, Formula> statModifiers = new HashMap();

        public Attribute(DataSection data, String key) {
            DataSection stats;
            this.key = key.toLowerCase();
            this.display = data.getString(DISPLAY, key);
            this.icon = Data.parseIcon(data);
            this.max = data.getInt(MAX, 999);
            DataSection globals = data.getSection(GLOBAL);
            if (globals != null) {
                this.loadGroup(globals.getSection(CONDITION), ComponentType.CONDITION);
                this.loadGroup(globals.getSection(MECHANIC), ComponentType.MECHANIC);
                this.loadGroup(globals.getSection(TARGET), ComponentType.TARGET);
            }
            if ((stats = data.getSection(STATS)) != null) {
                for (String stat : stats.keys()) {
                    this.loadStatModifier(stats, stat);
                }
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.display;
        }

        @Override
        public ItemStack getIcon(PlayerData data) {
            ItemStack item = new ItemStack(this.icon.getType());
            ItemMeta iconMeta = this.icon.getItemMeta();
            ItemMeta meta = item.getItemMeta();
            if (meta != null && iconMeta != null) {
                ArrayList lore;
                meta.setDisplayName(this.filter(data, iconMeta.getDisplayName()));
                List iconLore = iconMeta.getLore();
                List<Object> list = lore = iconLore != null ? iconLore.stream().map(iconLine -> this.filter(data, (String)iconLine)).collect(Collectors.toList()) : new ArrayList();
                if (meta instanceof Damageable) {
                    ((Damageable)meta).setDamage(((Damageable)iconMeta).getDamage());
                }
                if (iconMeta.hasCustomModelData()) {
                    meta.setCustomModelData(Integer.valueOf(iconMeta.getCustomModelData()));
                }
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            return DamageLoreRemover.removeAttackDmg(item);
        }

        @Override
        public boolean isAllowed(Player player) {
            return true;
        }

        private String filter(PlayerData data, String text) {
            return text.replace("{amount}", "" + data.getInvestedAttribute(this.key)).replace("{total}", "" + data.getAttribute(this.key));
        }

        public ItemStack getToolIcon() {
            ArrayList<String> lore;
            ItemStack icon = new ItemStack(this.icon.getType());
            ItemMeta meta = icon.getItemMeta();
            ItemMeta iconMeta = this.icon.getItemMeta();
            if (meta == null || iconMeta == null) {
                return icon;
            }
            meta.setDisplayName(this.key);
            ArrayList<String> arrayList = lore = iconMeta.hasLore() ? iconMeta.getLore() : null;
            if (lore == null) {
                lore = new ArrayList<String>();
            }
            if (iconMeta.hasDisplayName()) {
                lore.add(0, iconMeta.getDisplayName());
            }
            meta.setLore(lore);
            icon.setItemMeta(meta);
            return icon;
        }

        public int getMax() {
            return this.max;
        }

        public double modify(EffectComponent component, String key, double value, int amount) {
            key = component.getKey() + "-" + ((String)key).toLowerCase();
            Map<String, AttributeValue[]> map = this.dynamicModifiers.get((Object)component.getType());
            if (map.containsKey(key)) {
                AttributeValue[] list;
                for (AttributeValue attribValue : list = map.get(key)) {
                    if (!attribValue.passes(component)) continue;
                    return attribValue.apply(value, amount);
                }
            }
            return value;
        }

        public double modifyStat(String key, double base, int amount) {
            if (this.statModifiers.containsKey(key)) {
                return this.statModifiers.get(key).compute(base, amount);
            }
            return base;
        }

        private void loadGroup(DataSection data, ComponentType type) {
            if (data == null) {
                return;
            }
            Map target = this.dynamicModifiers.computeIfAbsent(type, t -> new HashMap());
            for (String key : data.keys()) {
                String lower = key.toLowerCase();
                Logger.log(LogType.ATTRIBUTE_LOAD, 2, "    SkillMod: " + key);
                String value = data.getString(key);
                String[] formulas = value.split("\\|");
                AttributeValue[] values = new AttributeValue[formulas.length];
                int i = 0;
                for (String formula : formulas) {
                    values[i++] = new AttributeValue(formula);
                }
                target.put(lower, values);
                if (!AttributeManager.this.byComponent.containsKey(lower)) {
                    AttributeManager.this.byComponent.put(lower, new ArrayList());
                }
                AttributeManager.this.byComponent.get(lower).add(this);
            }
        }

        private void loadStatModifier(DataSection data, String key) {
            if (data.has(key)) {
                Logger.log(LogType.ATTRIBUTE_LOAD, 2, "    StatMod: " + key);
                this.statModifiers.put(key, new Formula(data.getString(key, "v"), new CustomValue("v"), new CustomValue("a")));
                if (!AttributeManager.this.byStat.containsKey(key)) {
                    AttributeManager.this.byStat.put(key, new ArrayList());
                }
                AttributeManager.this.byStat.get(key).add(this);
            }
        }
    }

    public class AttributeValue {
        private Formula formula;
        private HashMap<String, String> conditions = new HashMap();

        public AttributeValue(String data) {
            String[] pieces = data.split(":");
            this.formula = new Formula(pieces[0], new CustomValue("v"), new CustomValue("a"));
            for (int i = 1; i < pieces.length; ++i) {
                String[] sides = pieces[i].split("=");
                this.conditions.put(sides[0], sides[1]);
                Logger.log(LogType.ATTRIBUTE_LOAD, 3, "      Condition: " + sides[0] + " / " + sides[1]);
            }
        }

        public boolean passes(EffectComponent component) {
            for (String key : this.conditions.keySet()) {
                if (component.getSettings().getString(key).equalsIgnoreCase(this.conditions.get(key))) continue;
                return false;
            }
            return true;
        }

        public double apply(double value, int amount) {
            return this.formula.compute(value, amount);
        }
    }
}

