/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.listener;

import com.sucy.skill.api.DefaultCombatProtection;
import com.sucy.skill.api.event.PlayerBlockDamageEvent;
import com.sucy.skill.listener.SkillAPIListener;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Statistic;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;

public class ShieldBlockListener
extends SkillAPIListener {
    private final HashMap<UUID, Entity> volatileMap = new HashMap();

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Player) || event instanceof DefaultCombatProtection.FakeEntityDamageByEntityEvent) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!player.isBlocking()) {
            return;
        }
        final UUID player_uuid = player.getUniqueId();
        this.volatileMap.put(player_uuid, event.getDamager());
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                ShieldBlockListener.this.volatileMap.remove(player_uuid);
            }
        }, 100L);
    }

    @EventHandler
    public void onStat(PlayerStatisticIncrementEvent event) {
        if (!event.getStatistic().equals((Object)Statistic.DAMAGE_BLOCKED_BY_SHIELD)) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.volatileMap.containsKey(player.getUniqueId())) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new PlayerBlockDamageEvent(this.volatileMap.get(player.getUniqueId()), event));
    }
}

