/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.listener;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.enums.ExpSource;
import com.sucy.skill.api.event.FlagApplyEvent;
import com.sucy.skill.api.event.FlagExpireEvent;
import com.sucy.skill.api.event.PlayerExperienceGainEvent;
import com.sucy.skill.api.event.PlayerLandEvent;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.projectile.ItemProjectile;
import com.sucy.skill.dynamic.mechanic.BlockMechanic;
import com.sucy.skill.dynamic.mechanic.LightningMechanic;
import com.sucy.skill.dynamic.mechanic.PotionProjectileMechanic;
import com.sucy.skill.dynamic.mechanic.ProjectileMechanic;
import com.sucy.skill.hook.DisguiseHook;
import com.sucy.skill.hook.PluginChecker;
import com.sucy.skill.hook.VaultHook;
import com.sucy.skill.listener.SkillAPIListener;
import com.sucy.skill.task.RemoveTask;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import mc.promcteam.engine.mccore.util.VersionManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;

public class MechanicListener
extends SkillAPIListener {
    public static final String SUMMON_DAMAGE = "sapiSumDamage";
    public static final String P_CALL = "pmCallback";
    public static final String NO_FIRE = "noFire";
    public static final String POTION_PROJECTILE = "potionProjectile";
    public static final String ITEM_PROJECTILE = "itemProjectile";
    public static final String SKILL_LEVEL = "skill_level";
    public static final String SKILL_CASTER = "caster";
    public static final String SPEED_KEY = "sapiSpeedKey";
    public static final String DISGUISE_KEY = "sapiDisguiseKey";
    public static final String ARMOR_STAND = "asMechanic";
    public static final String DAMAGE_CAUSE = "damageCause";
    private static final HashMap<UUID, Double> flying = new HashMap();
    private static Map<UUID, Double> exempt = new HashMap<UUID, Double>();

    @Override
    public void cleanup() {
        flying.clear();
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (event.getPlayer().hasMetadata("NPC")) {
            return;
        }
        boolean inMap = flying.containsKey(event.getPlayer().getUniqueId());
        if (inMap == this.isOnGround(event.getTo())) {
            if (inMap) {
                double maxHeight = flying.remove(event.getPlayer().getUniqueId());
                Bukkit.getPluginManager().callEvent((Event)new PlayerLandEvent(event.getPlayer(), maxHeight - event.getPlayer().getLocation().getY()));
            } else {
                flying.put(event.getPlayer().getUniqueId(), event.getPlayer().getLocation().getY());
            }
        } else if (inMap) {
            double y = flying.get(event.getPlayer().getUniqueId());
            flying.put(event.getPlayer().getUniqueId(), Math.max(y, event.getPlayer().getLocation().getY()));
        }
    }

    public boolean isOnGround(Location loc) {
        double dz;
        loc = loc.clone();
        HashSet<Block> blocksUnderneath = new HashSet<Block>();
        double dx = loc.getX() % 1.0;
        if (dx < 0.0) {
            dx += 1.0;
        }
        if ((dz = loc.getZ() % 1.0) < 0.0) {
            dz += 1.0;
        }
        blocksUnderneath.add(loc.getBlock());
        blocksUnderneath.add(loc.getBlock().getRelative(BlockFace.DOWN));
        if (this.fuzzyEquals(loc.getY() % 1.0, 0.5)) {
            loc.subtract(0.0, 0.5, 0.0);
        }
        loc.subtract(0.0, 0.07, 0.0);
        if (dx < 0.3) {
            blocksUnderneath.add(loc.clone().subtract(0.31, 0.0, 0.0).getBlock());
            if (dz < 0.3) {
                blocksUnderneath.add(loc.clone().subtract(0.31, 0.0, 0.31).getBlock());
            } else if (dz > 0.7) {
                blocksUnderneath.add(loc.clone().subtract(0.31, 0.0, -0.31).getBlock());
            }
        }
        if (dz < 0.3) {
            blocksUnderneath.add(loc.clone().subtract(0.0, 0.0, 0.31).getBlock());
        }
        if (dx > 0.7) {
            blocksUnderneath.add(loc.clone().add(0.31, 0.0, 0.0).getBlock());
            if (dz > 0.7) {
                blocksUnderneath.add(loc.clone().add(0.31, 0.0, 0.31).getBlock());
            } else if (dz < 0.3) {
                blocksUnderneath.add(loc.clone().add(0.31, 0.0, -0.31).getBlock());
            }
        }
        if (dz > 0.7) {
            blocksUnderneath.add(loc.clone().add(0.0, 0.0, 0.31).getBlock());
        }
        Location finalLoc = loc.clone();
        return blocksUnderneath.stream().anyMatch(b -> {
            boolean solid = !b.isPassable();
            BoundingBox box = b.getBoundingBox();
            box.expandDirectional(0.0, this.isTaller((Block)b) ? 0.5 : 0.0, 0.0);
            boolean bounded = this.isIntersecting(box, finalLoc);
            return solid && bounded;
        });
    }

    private boolean isTaller(Block b) {
        Material type = b.getType();
        String typeStr = type.toString();
        return typeStr.contains("WALL") || typeStr.contains("FENCE");
    }

    private boolean isIntersecting(BoundingBox box, Location loc) {
        boolean xContains = box.getMinX() <= loc.getX() && loc.getX() <= box.getMaxX() || this.fuzzyEquals(box.getMinX(), loc.getX(), 0.3) || this.fuzzyEquals(box.getMaxX(), loc.getX(), 0.3);
        boolean yContains = box.getMinY() <= loc.getY() && loc.getY() <= box.getMaxY();
        boolean zContains = box.getMinZ() <= loc.getZ() && loc.getZ() <= box.getMaxZ() || this.fuzzyEquals(box.getMinZ(), loc.getZ(), 0.3) || this.fuzzyEquals(box.getMaxZ(), loc.getZ(), 0.3);
        return xContains && yContains && zContains;
    }

    private boolean fuzzyEquals(double input, double expected) {
        return this.fuzzyEquals(input, expected, 0.07);
    }

    private boolean fuzzyEquals(double input, double expected, double epsilon) {
        return Math.abs(input - expected) < epsilon;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        flying.remove(event.getPlayer().getUniqueId());
        event.getPlayer().setWalkSpeed(0.2f);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onApply(FlagApplyEvent event) {
        if (event.getEntity() instanceof Player && event.getFlag().startsWith("perm:") && PluginChecker.isVaultPermissionsActive()) {
            VaultHook.addPermission((Player)event.getEntity(), event.getFlag().substring(5));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onExpire(FlagExpireEvent event) {
        if (event.getEntity() instanceof Player) {
            if (event.getFlag().startsWith("perm:") && PluginChecker.isVaultPermissionsActive()) {
                VaultHook.removePermission((Player)event.getEntity(), event.getFlag().substring(5));
            } else if (event.getFlag().startsWith("sapiSpeedKey:")) {
                Player player = (Player)event.getEntity();
                UUID uuid = UUID.fromString(event.getFlag().split(":")[1]);
                PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)player);
                data.removeStatModifier(uuid, false);
                data.updateWalkSpeed(player);
            }
        }
        if (event.getFlag().equals(DISGUISE_KEY)) {
            DisguiseHook.removeDisguise(event.getEntity());
        }
    }

    @EventHandler
    public void onLand(ProjectileHitEvent event) {
        if (event.getEntity().hasMetadata(P_CALL)) {
            SkillAPI.schedule(() -> {
                Object obj = SkillAPI.getMeta((Metadatable)event.getEntity(), P_CALL);
                if (obj != null) {
                    ((ProjectileMechanic)obj).callback(event.getEntity(), null);
                }
            }, 1);
        }
    }

    @EventHandler
    public void onItemPickup(InventoryPickupItemEvent event) {
        Object meta = SkillAPI.getMeta((Metadatable)event.getItem(), ITEM_PROJECTILE);
        if (meta != null) {
            event.setCancelled(true);
            ((ItemProjectile)meta).applyLanded();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onExperienceGain(PlayerExperienceGainEvent event) {
        Player player = event.getPlayerData().getPlayer();
        if (event.isCancelled() && event.getSource() == ExpSource.PLUGIN && exempt.containsKey(player.getUniqueId()) && exempt.get(player.getUniqueId()).doubleValue() == event.getExp()) {
            event.setCancelled(false);
        }
    }

    public static void addExemptExperience(Player player, double amount) {
        exempt.put(player.getUniqueId(), amount);
    }

    @EventHandler
    public void onExplode(EntityExplodeEvent event) {
        if (event.getEntity().hasMetadata(P_CALL)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDamageByEntity(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        Entity entity = event.getEntity();
        if (damager instanceof Projectile) {
            Projectile p = (Projectile)damager;
            if (p.hasMetadata(P_CALL) && entity instanceof LivingEntity) {
                ((ProjectileMechanic)SkillAPI.getMeta((Metadatable)p, P_CALL)).callback(p, (LivingEntity)entity);
                event.setCancelled(true);
            }
        } else if (damager instanceof LightningStrike && damager.hasMetadata(P_CALL) && entity instanceof LivingEntity) {
            double damage = Objects.requireNonNull((LightningMechanic.Callback)SkillAPI.getMeta((Metadatable)damager, P_CALL)).execute((LivingEntity)entity);
            if (damage <= 0.0) {
                event.setCancelled(true);
            } else {
                event.setDamage(damage);
            }
        }
    }

    @EventHandler
    public void combust(EntityCombustByEntityEvent event) {
        if (event.getCombuster() != null && event.getCombuster().hasMetadata(NO_FIRE)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void blockIgnite(BlockIgniteEvent event) {
        if (event.getIgnitingEntity() != null && event.getIgnitingEntity().hasMetadata(NO_FIRE)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onSummonDamage(EntityDamageByEntityEvent event) {
        if (event.getDamager().hasMetadata(SUMMON_DAMAGE)) {
            VersionManager.setDamage((EntityDamageEvent)event, (double)SkillAPI.getMetaDouble((Metadatable)event.getDamager(), SUMMON_DAMAGE));
        }
    }

    @EventHandler
    public void onSplash(PotionSplashEvent event) {
        if (event.getEntity().hasMetadata(POTION_PROJECTILE)) {
            event.setCancelled(true);
            ((PotionProjectileMechanic)SkillAPI.getMeta((Metadatable)event.getEntity(), POTION_PROJECTILE)).callback((Entity)event.getEntity(), event.getAffectedEntities());
            event.getAffectedEntities().clear();
        }
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        if (BlockMechanic.isPending(event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ArmorStand && SkillAPI.getMeta((Metadatable)entity, ARMOR_STAND) != null) {
            event.setCancelled(true);
        } else if (event.getCause().equals((Object)EntityDamageEvent.DamageCause.FIRE_TICK) && entity.hasMetadata("fireMechanic")) {
            event.setDamage(SkillAPI.getMetaDouble((Metadatable)entity, "fireMechanic"));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamageCause(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        List metadataList = entity.getMetadata(DAMAGE_CAUSE);
        if (metadataList.isEmpty()) {
            return;
        }
        Object metadataValue = ((MetadataValue)metadataList.get(0)).value();
        if (!(metadataValue instanceof EntityDamageEvent.DamageCause)) {
            return;
        }
        if (event.getCause() != metadataValue) {
            try {
                Field causeField = EntityDamageEvent.class.getDeclaredField("cause");
                causeField.setAccessible(true);
                causeField.set(event, metadataValue);
            }
            catch (Exception e) {
                new UnsupportedOperationException("Failed to change DamageCause", e).printStackTrace();
            }
        }
        entity.removeMetadata(DAMAGE_CAUSE, (Plugin)SkillAPI.inst());
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent event) {
        Entity entity = event.getEntity();
        if (entity.hasMetadata("fireMechanic")) {
            SkillAPI.removeMeta((Metadatable)entity, "fireMechanic");
        }
    }

    @EventHandler
    public void onArmorStandInteract(PlayerArmorStandManipulateEvent event) {
        ArmorStand entity = event.getRightClicked();
        if (SkillAPI.getMeta((Metadatable)entity, ARMOR_STAND) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Entity entity : event.getChunk().getEntities()) {
            if (!entity.hasMetadata("sapi_wolf_skills") && !entity.hasMetadata(ARMOR_STAND)) continue;
            entities.add(entity);
        }
        if (!entities.isEmpty()) {
            new RemoveTask(entities, 1);
        }
    }
}

