/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.listener;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.enums.ExpSource;
import com.sucy.skill.api.event.PlayerExperienceGainEvent;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.listener.SkillAPIListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.OptionalInt;
import java.util.Set;
import mc.promcteam.engine.mccore.config.CommentedConfig;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.CraftItemEvent;

public class ExperienceListener
extends SkillAPIListener {
    private static final String CONFIG_KEY = "unnatural";
    boolean track;
    HashSet<String> unnatural = new HashSet();

    public ExperienceListener() {
        this.track = SkillAPI.getSettings().isTrackBreak();
        if (this.track) {
            CommentedConfig data = SkillAPI.getConfig("data/placed");
            this.unnatural = new HashSet(data.getConfig().getList(CONFIG_KEY));
        }
    }

    @Override
    public void cleanup() {
        if (this.track) {
            CommentedConfig config = SkillAPI.getConfig("data/placed");
            config.getConfig().set(CONFIG_KEY, new ArrayList<String>(this.unnatural));
            config.save();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBreak(BlockBreakEvent event) {
        if (this.track && this.unnatural.contains(this.format(event.getBlock()))) {
            return;
        }
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)event.getPlayer());
        for (PlayerClass playerClass : playerData.getClasses()) {
            double yield = SkillAPI.getSettings().getBreakYield(playerClass, event.getBlock().getType());
            if (!(yield > 0.0)) continue;
            playerClass.giveExp(yield, ExpSource.BLOCK_BREAK);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlace(BlockPlaceEvent event) {
        if (this.track) {
            this.unnatural.add(this.format(event.getBlock()));
        }
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)event.getPlayer());
        for (PlayerClass playerClass : playerData.getClasses()) {
            double yield = SkillAPI.getSettings().getPlaceYield(playerClass, event.getBlock().getType());
            if (!(yield > 0.0)) continue;
            playerClass.giveExp(yield, ExpSource.BLOCK_PLACE);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCraft(CraftItemEvent event) {
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)((Player)event.getWhoClicked()));
        for (PlayerClass playerClass : playerData.getClasses()) {
            double yield = SkillAPI.getSettings().getCraftYield(playerClass, event.getRecipe().getResult().getType());
            if (!(yield > 0.0)) continue;
            playerClass.giveExp(yield, ExpSource.CRAFT);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExpGain(PlayerExperienceGainEvent event) {
        Player player = event.getPlayerData().getPlayer();
        Set perms = player.getEffectivePermissions();
        OptionalInt max = perms.stream().filter(c -> c.getPermission().startsWith("skillapi.exp.booster")).map(c -> c.getPermission().substring(21)).mapToInt(number -> {
            try {
                return Integer.parseInt(number);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }).max();
        if (max.isEmpty()) {
            return;
        }
        event.setExp(event.getExp() * (double)max.getAsInt() / 100.0);
    }

    private String format(Block block) {
        Location loc = block.getLocation();
        return loc.getWorld().getName() + "|" + loc.getBlockX() + "|" + loc.getBlockY() + "|" + loc.getBlockZ();
    }
}

