/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.listener;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.event.PlayerAccountChangeEvent;
import com.sucy.skill.api.event.PlayerClassChangeEvent;
import com.sucy.skill.api.event.PlayerSkillDowngradeEvent;
import com.sucy.skill.api.event.PlayerSkillUnlockEvent;
import com.sucy.skill.api.event.PlayerSkillUpgradeEvent;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.player.PlayerSkillBar;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.gui.handlers.SkillHandler;
import com.sucy.skill.gui.map.SkillDetailMenu;
import com.sucy.skill.gui.map.SkillListMenu;
import com.sucy.skill.hook.CitizensHook;
import com.sucy.skill.listener.MainListener;
import com.sucy.skill.listener.SkillAPIListener;
import java.util.HashSet;
import java.util.UUID;
import mc.promcteam.engine.mccore.gui.MapData;
import mc.promcteam.engine.mccore.gui.MapMenu;
import mc.promcteam.engine.mccore.gui.MapMenuManager;
import mc.promcteam.engine.mccore.util.VersionManager;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class BarListener
extends SkillAPIListener {
    private final HashSet<UUID> ignored = new HashSet();

    @Override
    public void init() {
        MainListener.registerJoin(this::onJoin);
        MainListener.registerClear(this::handleClear);
        for (Player player : VersionManager.getOnlinePlayers()) {
            PlayerData data;
            if (!SkillAPI.getSettings().isWorldEnabled(player.getWorld()) || !(data = SkillAPI.getPlayerData((OfflinePlayer)player)).hasClass()) continue;
            data.getSkillBar().setup((HumanEntity)player);
        }
    }

    @Override
    public void cleanup() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!SkillAPI.getSettings().isWorldEnabled(player.getWorld())) continue;
            this.cleanup(player);
        }
    }

    private void cleanup(Player player) {
        PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)player);
        if (data.getSkillBar().isSetup()) {
            data.getSkillBar().clear(player);
        }
        this.ignored.remove(player.getUniqueId());
    }

    public void onJoin(Player player) {
        PlayerData data;
        if (SkillAPI.getSettings().isWorldEnabled(player.getWorld()) && (data = SkillAPI.getPlayerData((OfflinePlayer)player)).hasClass()) {
            data.getSkillBar().setup((HumanEntity)player);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.cleanup(event.getPlayer());
    }

    @EventHandler
    public void onProfess(PlayerClassChangeEvent event) {
        Player p = event.getPlayerData().getPlayer();
        if (!SkillAPI.getSettings().isWorldEnabled(p.getWorld())) {
            return;
        }
        if (event.getPreviousClass() == null && event.getNewClass() != null) {
            PlayerSkillBar bar = event.getPlayerData().getSkillBar();
            if (!bar.isSetup()) {
                bar.setup((HumanEntity)p);
            }
        } else if (event.getPreviousClass() != null && event.getNewClass() == null) {
            PlayerSkillBar bar = event.getPlayerData().getSkillBar();
            bar.reset();
            bar.clear(p);
        }
    }

    @EventHandler
    public void onUnlock(PlayerSkillUnlockEvent event) {
        if (!event.getUnlockedSkill().getData().canCast() || event.getPlayerData().getPlayer() == null) {
            return;
        }
        event.getPlayerData().getSkillBar().unlock(event.getUnlockedSkill());
    }

    @EventHandler
    public void onUpgrade(PlayerSkillUpgradeEvent event) {
        Player player = event.getPlayerData().getPlayer();
        if (player != null && event.getPlayerData().getSkillBar().isSetup()) {
            SkillAPI.schedule(() -> event.getPlayerData().getSkillBar().update((HumanEntity)player), 0);
        }
    }

    @EventHandler
    public void onDowngrade(PlayerSkillDowngradeEvent event) {
        if (event.getPlayerData().getSkillBar().isSetup()) {
            SkillAPI.schedule(() -> SkillAPI.getPlayerData((OfflinePlayer)event.getPlayerData().getPlayer()).getSkillBar().update((HumanEntity)event.getPlayerData().getPlayer()), 1);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDeath(PlayerDeathEvent event) {
        if (CitizensHook.isNPC((Entity)event.getEntity()) || !SkillAPI.getSettings().isWorldEnabled(event.getEntity().getWorld())) {
            return;
        }
        PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)event.getEntity());
        if (data.getSkillBar().isSetup()) {
            for (int i = 0; i < 9; ++i) {
                if (data.getSkillBar().isWeaponSlot(i)) continue;
                event.getDrops().remove(event.getEntity().getInventory().getItem(i));
            }
            data.getSkillBar().clear(event.getEntity());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onRespawn(PlayerRespawnEvent event) {
        if (!SkillAPI.getSettings().isWorldEnabled(event.getPlayer().getWorld())) {
            return;
        }
        PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)event.getPlayer());
        if (data.hasClass()) {
            data.getSkillBar().setup((HumanEntity)event.getPlayer());
            data.getSkillBar().update((HumanEntity)event.getPlayer());
            if (data.getSkillBar().isSetup() && SkillAPI.getSettings().isWorldEnabled(event.getRespawnLocation().getWorld()) && !data.getSkillBar().isWeaponSlot(0)) {
                this.ignored.add(event.getPlayer().getUniqueId());
            }
        }
    }

    @EventHandler
    public void onAssign(InventoryClickEvent event) {
        SkillHandler handler;
        Skill skill;
        PlayerData data;
        if (event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD && event.getInventory().getHolder() instanceof SkillHandler && (data = SkillAPI.getPlayerData((OfflinePlayer)((Player)event.getWhoClicked()))).getSkillBar().isSetup() && !data.getSkillBar().isWeaponSlot(event.getHotbarButton()) && (skill = (Skill)(handler = (SkillHandler)event.getInventory().getHolder()).get(event.getSlot())) != null && skill.canCast()) {
            data.getSkillBar().assign(data.getSkill(skill.getName()), event.getHotbarButton());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onToggle(InventoryClickEvent event) {
        PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)((Player)event.getWhoClicked()));
        PlayerSkillBar skillBar = data.getSkillBar();
        if (!skillBar.isSetup()) {
            return;
        }
        if (!(event.getAction() != InventoryAction.HOTBAR_SWAP && event.getAction() != InventoryAction.HOTBAR_MOVE_AND_READD || skillBar.isWeaponSlot(event.getHotbarButton()) && skillBar.isWeaponSlot(event.getSlot()))) {
            event.setCancelled(true);
            return;
        }
        int slot = event.getSlot();
        if (event.getSlot() < 9 && event.getRawSlot() > event.getView().getTopInventory().getSize()) {
            if (event.getClick() == ClickType.LEFT || event.getClick() == ClickType.SHIFT_LEFT) {
                event.setCancelled(!skillBar.isWeaponSlot(slot));
            } else if (!(event.getClick() != ClickType.RIGHT && event.getClick() != ClickType.SHIFT_RIGHT || skillBar.isWeaponSlot(slot) && (!skillBar.isWeaponSlot(slot) || event.getCurrentItem() != null && event.getCurrentItem().getType() != Material.AIR))) {
                event.setCancelled(true);
                skillBar.toggleSlot(slot);
            } else if (event.getAction().name().startsWith("DROP")) {
                event.setCancelled(!skillBar.isWeaponSlot(slot));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChangeWorldPre(PlayerChangedWorldEvent event) {
        PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)event.getPlayer());
        boolean enabled = SkillAPI.getSettings().isWorldEnabled(event.getPlayer().getWorld());
        if (data.hasClass() && data.getSkillBar().isSetup() && enabled) {
            this.ignored.add(event.getPlayer().getUniqueId());
        }
        if (!enabled) {
            data.getSkillBar().clear(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChangeWorld(PlayerChangedWorldEvent event) {
        PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)event.getPlayer());
        boolean enabled = SkillAPI.getSettings().isWorldEnabled(event.getPlayer().getWorld());
        if (enabled) {
            data.getSkillBar().setup((HumanEntity)event.getPlayer());
        }
    }

    @EventHandler
    public void onCast(PlayerItemHeldEvent event) {
        PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)event.getPlayer());
        if (!data.hasClass()) {
            return;
        }
        PlayerSkillBar bar = data.getSkillBar();
        if (!bar.isWeaponSlot(event.getNewSlot()) && bar.isSetup()) {
            event.setCancelled(true);
            if (this.ignored.remove(event.getPlayer().getUniqueId())) {
                return;
            }
            MapData held = MapMenuManager.getActiveMenuData((Player)event.getPlayer());
            if (held != null) {
                MapMenu menu = held.getMenu(event.getPlayer());
                if (menu instanceof SkillListMenu || menu instanceof SkillDetailMenu) {
                    bar.assign(SkillListMenu.getSkill(event.getPlayer()), event.getNewSlot());
                }
            } else {
                bar.apply(event.getNewSlot());
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChangeAccount(PlayerAccountChangeEvent event) {
        PlayerSkillBar bar = event.getPreviousAccount().getSkillBar();
        if (bar.isSetup()) {
            bar.clear(event.getPreviousAccount().getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChangeMode(PlayerGameModeChangeEvent event) {
        PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)event.getPlayer());
        if (event.getNewGameMode() == GameMode.CREATIVE && data.hasClass()) {
            data.getSkillBar().clear(event.getPlayer());
        } else if (event.getPlayer().getGameMode() == GameMode.CREATIVE && data.hasClass()) {
            Player player = event.getPlayer();
            SkillAPI.schedule(() -> SkillAPI.getPlayerData((OfflinePlayer)player).getSkillBar().setup((HumanEntity)player), 0);
        }
    }

    private void handleClear(Player player) {
        PlayerSkillBar skillBar = SkillAPI.getPlayerData((OfflinePlayer)player).getSkillBar();
        if (skillBar.isSetup()) {
            skillBar.update((HumanEntity)player);
        }
    }
}

