/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.hook.mimic;

import com.sucy.skill.hook.mimic.ProSkillApiClassSystem;
import com.sucy.skill.hook.mimic.ProSkillApiLevelSystem;
import com.sucy.skill.log.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import ru.endlesscode.mimic.Mimic;
import ru.endlesscode.mimic.MimicApiLevel;

public class MimicHook {
    private static boolean hooked = false;

    public static boolean isHooked() {
        return hooked;
    }

    public static void init(Plugin plugin) {
        if (Bukkit.getPluginManager().getPlugin("Mimic") == null) {
            return;
        }
        if (!MimicApiLevel.checkApiLevel((int)3)) {
            Logger.bug("At least Mimic 0.7 is required. Please download it from https://www.spigotmc.org/resources/82515/");
            return;
        }
        try {
            MimicHook.registerMimicServices(plugin);
            hooked = true;
        }
        catch (Exception ex) {
            Logger.bug("Mimic hook failed: " + ex.getLocalizedMessage());
        }
    }

    private static void registerMimicServices(Plugin plugin) {
        Mimic mimic = Mimic.getInstance();
        mimic.registerClassSystem(ProSkillApiClassSystem::new, 4, plugin);
        mimic.registerLevelSystem(ProSkillApiLevelSystem::new, 4, plugin);
    }
}

