/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.hook;

import com.sucy.skill.SkillAPI;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook {
    private static Permission permission;
    private static Economy economy;
    private static boolean checked;

    private static void initialize() {
        block5: {
            try {
                RegisteredServiceProvider economyProvider;
                RegisteredServiceProvider permissionProvider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
                if (permissionProvider != null) {
                    permission = (Permission)permissionProvider.getProvider();
                }
                if ((economyProvider = Bukkit.getServer().getServicesManager().getRegistration(Economy.class)) != null) {
                    economy = (Economy)economyProvider.getProvider();
                }
            }
            catch (NoClassDefFoundError e) {
                if (permission == null) {
                    SkillAPI.inst().getLogger().info("Vault permissions not found. Permissions support as such will not be provided");
                }
                if (economy != null) break block5;
                SkillAPI.inst().getLogger().info("Vault economy not found. Economy support as such will not be provided");
            }
        }
    }

    public static boolean isPermissionsValid() {
        if (!checked) {
            VaultHook.initialize();
            checked = true;
        }
        return permission != null;
    }

    public static void addPermission(Player player, String node) {
        permission.playerAdd(player, node);
    }

    public static void removePermission(Player player, String node) {
        permission.playerRemove(player, node);
    }

    public static boolean hasPermission(Player player, String node) {
        return permission.has(player, node);
    }

    public static boolean isEconomyValid() {
        if (!checked) {
            VaultHook.initialize();
            checked = true;
        }
        return economy != null;
    }

    public static double getBalance(Player player) {
        return economy.getBalance((OfflinePlayer)player, player.getWorld().getName());
    }

    public static Boolean hasBalance(Player player, double balance) {
        return !(VaultHook.getBalance(player) < balance);
    }

    public static EconomyResponse withdraw(Player player, double amount) {
        return economy.withdrawPlayer((OfflinePlayer)player, player.getWorld().getName(), amount);
    }

    public static EconomyResponse deposit(Player player, double amount) {
        return economy.depositPlayer((OfflinePlayer)player, player.getWorld().getName(), amount);
    }

    static {
        checked = false;
    }
}

