/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.gui.tool;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.api.util.DamageLoreRemover;
import com.sucy.skill.gui.tool.GUIData;
import com.sucy.skill.gui.tool.GUIPage;
import com.sucy.skill.gui.tool.GUIType;
import com.sucy.skill.gui.tool.InventoryData;
import com.sucy.skill.gui.tool.ToolMenu;
import com.sucy.skill.log.Logger;
import com.sucy.skill.manager.AttributeManager;
import com.sucy.skill.tree.basic.CustomTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mc.promcteam.engine.mccore.config.CommentedConfig;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import mc.promcteam.engine.mccore.util.TextFormatter;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class GUITool
implements ToolMenu {
    private static final String NEXT_PAGE = "NEXT_PAGE";
    private static final String PREV_PAGE = "PREV_PAGE";
    private static final HashMap<String, GUIData> setups = new HashMap();
    private static final HashMap<String, ItemStack> items = new HashMap();
    private static boolean inUse = false;
    private static CommentedConfig config;
    private static final NamespacedKey CAST_ITEM_KEY;
    private static ItemStack NEXT;
    private static ItemStack PREV;
    private static ItemStack SHRINK;
    private static ItemStack GROW;
    private static ItemStack ADD_PAGE;
    private static ItemStack DEL_PAGE;
    private static ItemStack NEXT_CLASS;
    private static ItemStack PREV_CLASS;
    private static ItemStack NEXT_PROFESSION;
    private static ItemStack PREV_PROFESSION;
    private static RPGClass[] availableClasses;
    private static RPGClass[] availableProfesses;
    private static String[] availableGroups;
    private static GUIType type;
    private static int classId;
    private static int professId;
    private final Player player;
    private InventoryData data;
    private Inventory inventory;
    private RPGClass rpgClass;
    private Skill skill;
    private GUIData guiData;
    private ItemStack[] playerContents;
    private ItemStack[] inventoryContents;
    private int i;
    private boolean switching = false;

    public GUITool(Player player) {
        this.player = player;
    }

    public static boolean isInUse() {
        return inUse;
    }

    public static void init() {
        if (NEXT != null) {
            return;
        }
        NEXT = GUITool.make(Material.BOOK, ChatColor.GOLD + "Next Menu", new String[0]);
        PREV = GUITool.make(Material.BOOK, ChatColor.GOLD + "Previous Menu", new String[0]);
        SHRINK = GUITool.make(Material.MELON_SEEDS, ChatColor.GOLD + "Shrink", "", "Removes a row from the GUI");
        GROW = GUITool.make(Material.MELON, ChatColor.GOLD + "Grow", "", "Adds a row to the GUI");
        ADD_PAGE = GUITool.make(Material.PAPER, ChatColor.GOLD + "Add Page", "", "Adds another page to the GUI", "right after the current one");
        DEL_PAGE = GUITool.make(Material.PAPER, ChatColor.GOLD + "Delete Page", "", "Deletes the currently", "viewed page");
        NEXT_CLASS = GUITool.make(Material.DIAMOND_SWORD, ChatColor.GOLD + "Next Class", new String[0]);
        PREV_CLASS = GUITool.make(Material.IRON_SWORD, ChatColor.GOLD + "Previous Class", new String[0]);
        NEXT_PROFESSION = GUITool.make(Material.DIAMOND_HOE, ChatColor.GOLD + "Next Profession", new String[0]);
        PREV_PROFESSION = GUITool.make(Material.IRON_HOE, ChatColor.GOLD + "Previous Profession", new String[0]);
        availableClasses = SkillAPI.getClasses().values().toArray(new RPGClass[SkillAPI.getClasses().size()]);
        HashSet<RPGClass> professes = new HashSet<RPGClass>();
        HashSet<String> groups = new HashSet<String>();
        professes.add(null);
        config = SkillAPI.getConfig("gui");
        DataSection data = config.getConfig();
        for (String key : data.keys()) {
            try {
                GUIData loaded = new GUIData(data.getSection(key));
                if (!loaded.isValid()) continue;
                setups.put(key, loaded);
            }
            catch (IllegalArgumentException e) {
                SkillAPI.inst().getLogger().warning("Failed to load GUI data for " + key);
                e.printStackTrace();
            }
        }
        for (RPGClass c : availableClasses) {
            if (!(c.getSkillTree() instanceof CustomTree)) {
                try {
                    setups.put(GUIType.SKILL_TREE.getPrefix() + c.getName(), new GUIData(c.getSkillTree()));
                }
                catch (IllegalArgumentException e) {
                    SkillAPI.inst().getLogger().warning("Failed to load skill tree for " + c.getName());
                    e.printStackTrace();
                }
            }
            if (c.hasParent()) {
                professes.add(c.getParent());
            }
            groups.add(c.getGroup());
        }
        availableGroups = groups.toArray(new String[groups.size()]);
        availableProfesses = professes.toArray(new RPGClass[professes.size()]);
        CommentedConfig itemFile = SkillAPI.getConfig("tool");
        itemFile.checkDefaults();
        itemFile.save();
        DataSection custom = itemFile.getConfig();
        for (String key : custom.keys()) {
            try {
                ItemStack item = GUITool.parseItem(custom.getSection(key));
                items.put(key.toUpperCase(), item);
            }
            catch (Exception ex) {
                Logger.invalid("Bad custom tool item: " + key);
            }
        }
    }

    public static ItemStack parseItem(DataSection data) {
        Material material = Material.valueOf((String)data.getString("type").toUpperCase().replace(" ", "_"));
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setCustomModelData(Integer.valueOf(data.getInt("data")));
            if (meta instanceof Damageable) {
                ((Damageable)meta).setDamage(data.getInt("durability"));
            }
            meta.setDisplayName(TextFormatter.colorString((String)data.getString("name")));
            meta.setLore(TextFormatter.colorStringList((List)data.getList("lore")));
            item.setItemMeta(meta);
        }
        return DamageLoreRemover.removeAttackDmg(item);
    }

    public static ItemStack markCastItem(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(CAST_ITEM_KEY, PersistentDataType.BYTE, (Object)1);
            itemStack.setItemMeta(meta);
        }
        return itemStack;
    }

    public static boolean isCastItem(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            Byte data = (Byte)meta.getPersistentDataContainer().get(CAST_ITEM_KEY, PersistentDataType.BYTE);
            return data != null && data >= 1;
        }
        return false;
    }

    public static void removeCastItems(Player player) {
        ItemStack[] contents = player.getInventory().getContents();
        for (int i = 0; i < contents.length; ++i) {
            if (!GUITool.isCastItem(contents[i])) continue;
            player.getInventory().setItem(i, null);
        }
    }

    public static void cleanUp() {
        if (config != null) {
            config.clear();
            DataSection data = config.getConfig();
            for (Map.Entry<String, GUIData> entry : setups.entrySet()) {
                if (!entry.getValue().isValid()) continue;
                entry.getValue().save(data.createSection(entry.getKey()));
            }
            config.save();
        }
        setups.clear();
        items.clear();
        config = null;
        NEXT = null;
        PREV = null;
        SHRINK = null;
        GROW = null;
        ADD_PAGE = null;
        DEL_PAGE = null;
        NEXT_CLASS = null;
        PREV_CLASS = null;
        NEXT_PROFESSION = null;
        PREV_PROFESSION = null;
        availableClasses = null;
        availableProfesses = null;
        availableGroups = null;
    }

    public static ItemStack getIcon(String key) {
        return items.get(key.toUpperCase());
    }

    public static boolean hasData(String key) {
        return setups.containsKey(key) && setups.get(key).isValid();
    }

    public static GUIData getSkillTree(RPGClass rpgClass) {
        return GUITool.get(GUIType.SKILL_TREE.getPrefix() + rpgClass.getName());
    }

    public static GUIData getProfessMenu(RPGClass current) {
        return GUITool.get((String)(current == null ? GUIType.CLASS_SELECTION.name() : GUIType.CLASS_SELECTION.getPrefix() + current.getName()));
    }

    public static GUIData getDetailsMenu() {
        return GUITool.get(GUIType.CLASS_DETAILS.name());
    }

    public static GUIData getAttributesMenu() {
        return GUITool.get(GUIType.ATTRIBUTES.name());
    }

    private static GUIData get(String key) {
        if (!setups.containsKey(key)) {
            setups.put(key, new GUIData());
        }
        return setups.get(key);
    }

    public static GUIData getActiveData() {
        Object key = type.getPrefix();
        switch (type) {
            case CLASS_SELECTION: {
                if (professId == 0) {
                    key = type.name();
                    break;
                }
                if (availableProfesses.length <= professId) break;
                key = (String)key + availableProfesses[professId].getName();
                break;
            }
            case CLASS_DETAILS: {
                key = type.name();
                break;
            }
            case SKILL_TREE: {
                if (availableClasses.length <= classId) break;
                key = (String)key + availableClasses[classId].getName();
                break;
            }
            case ATTRIBUTES: {
                key = type.name();
            }
        }
        return GUITool.get((String)key);
    }

    private static ItemStack make(Material mat, String name, String ... lore) {
        ItemStack item = new ItemStack(mat);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(Arrays.asList(lore));
            item.setItemMeta(meta);
        }
        return item;
    }

    public static void addPageButtons(ItemStack[] contents) {
        if (contents.length > 9) {
            contents[8] = items.get(PREV_PAGE);
            contents[17] = items.get(NEXT_PAGE);
        } else {
            contents[7] = items.get(PREV_PAGE);
            contents[8] = items.get(NEXT_PAGE);
        }
    }

    public void open() {
        if (!inUse) {
            PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)this.player);
            if (data.hasClass() && SkillAPI.getSettings().isSkillBarEnabled()) {
                data.getSkillBar().clear(this.player);
            }
            this.data = new InventoryData(this.player);
            this.setType(GUIType.CLASS_SELECTION);
            inUse = true;
        }
    }

    public void setType(GUIType type) {
        GUITool.type = type;
        this.guiData = GUITool.getActiveData();
        this.inventoryContents = new ItemStack[this.guiData.getSize()];
        String title = this.populate();
        this.inventory = this.player.getServer().createInventory((InventoryHolder)this, this.guiData.getSize(), title);
        this.inventory.setContents(this.inventoryContents);
        this.player.getInventory().setContents(this.playerContents);
        this.switching = true;
        this.player.openInventory(this.inventory);
        this.switching = false;
    }

    private void update() {
        this.inventoryContents = this.inventory.getContents();
        this.guiData.load(this.inventoryContents);
        if (type == GUIType.SKILL_TREE) {
            RPGClass rpgClass = availableClasses[classId];
            String name = GUIType.SKILL_TREE.getPrefix() + rpgClass.getName();
            this.guiData.save(config.getConfig().createSection(name));
            config.save();
            if (!(rpgClass.getSkillTree() instanceof CustomTree)) {
                rpgClass.reloadSkillTree();
                this.guiData = new GUIData(rpgClass.getSkillTree());
            }
            setups.put(name, this.guiData);
        }
    }

    private String populate() {
        this.playerContents = new ItemStack[36];
        this.playerContents[0] = PREV;
        this.playerContents[1] = NEXT;
        this.playerContents[2] = SHRINK;
        this.playerContents[3] = GROW;
        this.playerContents[4] = ADD_PAGE;
        this.playerContents[5] = DEL_PAGE;
        String name = null;
        switch (type) {
            case CLASS_DETAILS: {
                name = this.populateClassDetails();
                break;
            }
            case SKILL_TREE: {
                name = this.populateSkillTree();
                break;
            }
            case CLASS_SELECTION: {
                name = this.populateClassSelection();
                break;
            }
            case ATTRIBUTES: {
                name = this.populateAttributes();
            }
        }
        GUIPage page = this.guiData.getPage();
        for (Map.Entry<String, ItemStack> entry : items.entrySet()) {
            int index;
            if (entry.getKey().equals(NEXT_PAGE) || entry.getKey().equals(PREV_PAGE)) continue;
            if (this.i < this.playerContents.length) {
                this.playerContents[this.i++] = this.toPlaceholder(entry.getKey(), entry.getValue());
            }
            if ((index = page.getIndex(entry.getKey())) < 0) continue;
            this.inventoryContents[index] = this.toPlaceholder(entry.getKey(), entry.getValue());
        }
        if (this.guiData.getPages() > 1) {
            GUITool.addPageButtons(this.inventoryContents);
        }
        return name;
    }

    private ItemStack toPlaceholder(String key, ItemStack custom) {
        ItemStack copy = custom.clone();
        ItemMeta meta = copy.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(key);
            meta.setLore(new ArrayList());
            copy.setItemMeta(meta);
        }
        return copy;
    }

    private String populateClassSelection() {
        this.playerContents[7] = PREV_PROFESSION;
        this.playerContents[8] = NEXT_PROFESSION;
        GUIPage page = this.guiData.getPage();
        RPGClass profession = availableProfesses[professId];
        this.i = 9;
        for (RPGClass c : availableClasses) {
            if (c.getParent() != profession) continue;
            int index = page.getIndex(c.getName());
            if (index != -1) {
                this.inventoryContents[index] = c.getToolIcon();
                continue;
            }
            if (this.guiData.has(c.getName()) || this.i >= this.playerContents.length) continue;
            this.playerContents[this.i++] = c.getToolIcon();
        }
        if (profession == null) {
            return "Class Selection";
        }
        return this.limit(profession.getName() + " / Sub-profession");
    }

    private String limit(String text) {
        return text.substring(0, Math.min(text.length(), 32));
    }

    private String populateClassDetails() {
        this.i = 9;
        GUIPage page = this.guiData.getPage();
        for (String group : availableGroups) {
            ItemStack item = GUITool.make(Material.DRAGON_EGG, group, "", "Spot for the player's current", "class in the group should", "be placed in the GUI");
            int index = page.getIndex(group);
            if (index != -1) {
                this.inventoryContents[index] = item;
                continue;
            }
            if (this.guiData.has(group) || this.i >= this.playerContents.length) continue;
            this.playerContents[this.i++] = item;
        }
        return "GUI Editor - Class Details";
    }

    private String populateSkillTree() {
        this.playerContents[7] = PREV_CLASS;
        this.playerContents[8] = NEXT_CLASS;
        GUIPage page = this.guiData.getPage();
        this.i = 9;
        HashSet<Skill> skills = new HashSet<Skill>();
        for (RPGClass current = availableClasses[classId]; current != null; current = current.getParent()) {
            skills.addAll(current.getSkills());
        }
        for (Skill skill : skills) {
            int index = page.getIndex(skill.getName());
            if (index != -1 && index < this.inventoryContents.length) {
                this.inventoryContents[index] = skill.getToolIndicator();
                continue;
            }
            if (this.guiData.has(skill.getName()) || this.i >= this.playerContents.length) continue;
            this.playerContents[this.i++] = skill.getToolIndicator();
        }
        return this.limit(availableClasses[classId].getName() + " / Skill Tree");
    }

    private String populateAttributes() {
        this.i = 9;
        GUIPage page = this.guiData.getPage();
        for (String key : SkillAPI.getAttributeManager().getKeys()) {
            AttributeManager.Attribute attr = SkillAPI.getAttributeManager().getAttribute(key);
            int index = page.getIndex(attr.getKey());
            if (index != -1) {
                this.inventoryContents[index] = attr.getToolIcon();
                continue;
            }
            if (this.guiData.has(attr.getKey()) || this.i >= this.playerContents.length) continue;
            this.playerContents[this.i++] = attr.getToolIcon();
        }
        return "GUI Editor - Attributes";
    }

    @Override
    public void handleClick(InventoryClickEvent event) {
        if (event.getAction() == InventoryAction.HOTBAR_SWAP || event.getAction() == InventoryAction.HOTBAR_MOVE_AND_READD) {
            event.setCancelled(true);
        } else if (event.getRawSlot() < event.getView().getTopInventory().getSize()) {
            if (this.guiData.getPages() > 1) {
                if (this.guiData.getSize() > 9) {
                    switch (event.getSlot()) {
                        case 8: {
                            this.update();
                            this.guiData.prev();
                            this.setType(type);
                            event.setCancelled(true);
                            break;
                        }
                        case 17: {
                            this.update();
                            this.guiData.next();
                            this.setType(type);
                            event.setCancelled(true);
                        }
                    }
                } else {
                    switch (event.getSlot()) {
                        case 7: {
                            this.update();
                            this.guiData.prev();
                            this.setType(type);
                            event.setCancelled(true);
                            break;
                        }
                        case 8: {
                            this.update();
                            this.guiData.next();
                            this.setType(type);
                            event.setCancelled(true);
                        }
                    }
                }
            }
            if (!this.guiData.isEditable()) {
                event.setCancelled(true);
            }
        } else {
            if (event.getSlot() < 9) {
                this.update();
                event.setCancelled(true);
            }
            block8 : switch (event.getSlot()) {
                case 0: {
                    this.setType(type.prev());
                    break;
                }
                case 1: {
                    this.setType(type.next());
                    break;
                }
                case 2: {
                    this.guiData.shrink();
                    this.update();
                    this.setType(type);
                    break;
                }
                case 3: {
                    this.guiData.grow();
                    this.update();
                    this.setType(type);
                    break;
                }
                case 4: {
                    this.guiData.addPage();
                    this.setType(type);
                    break;
                }
                case 5: {
                    this.guiData.removePage();
                    this.setType(type);
                    break;
                }
                case 7: {
                    switch (type) {
                        case CLASS_SELECTION: {
                            professId = (professId + 1) % availableProfesses.length;
                            this.setType(type);
                            break;
                        }
                        case SKILL_TREE: {
                            classId = (classId + 1) % availableClasses.length;
                            this.setType(type);
                        }
                    }
                    break;
                }
                case 8: {
                    switch (type) {
                        case CLASS_SELECTION: {
                            professId = (professId + availableProfesses.length - 1) % availableProfesses.length;
                            this.setType(type);
                            break block8;
                        }
                        case SKILL_TREE: {
                            classId = (classId + availableClasses.length - 1) % availableClasses.length;
                            this.setType(type);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void restore() {
        if (this.data != null && !this.switching) {
            this.update();
            this.data.restore(this.player);
            this.data = null;
            inUse = false;
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    static {
        CAST_ITEM_KEY = new NamespacedKey((Plugin)SkillAPI.inst(), "castItem");
    }
}

