/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.gui.map;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.player.PlayerSkill;
import com.sucy.skill.gui.map.Menu;
import java.util.ArrayList;
import mc.promcteam.engine.mccore.gui.MapBuffer;
import mc.promcteam.engine.mccore.gui.MapImage;
import mc.promcteam.engine.mccore.gui.MapMenu;
import mc.promcteam.engine.mccore.gui.MapMenuManager;
import mc.promcteam.engine.mccore.gui.MapObject;
import mc.promcteam.engine.mccore.gui.MapScene;
import mc.promcteam.engine.mccore.gui.MapScheme;
import mc.promcteam.engine.mccore.gui.MapString;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class SkillListMenu
extends MapMenu {
    private static final String SELECTION = "sapi_skill";
    private static final String AVAILABLE = "sapi_available";
    private static final String PLATE = "plate";
    private static final String NAME = "name";
    private static final String SELECTOR = "selector";
    private static final String TITLE = "title";
    private SkillAPI api;

    public SkillListMenu(SkillAPI api) {
        this.api = api;
    }

    public static PlayerSkill getSkill(Player player) {
        Object skill = SkillListMenu.getData((Player)player, (String)SELECTION);
        ArrayList<PlayerSkill> list = SkillListMenu.getSkills(player);
        if (skill == null || list == null) {
            return null;
        }
        return list.get((Integer)skill);
    }

    private static int getId(Player player) {
        return SkillListMenu.getSelection((Player)player) & 0xFF;
    }

    private static int getScroll(Player player) {
        return SkillListMenu.getSelection((Player)player) >> 8;
    }

    private static void setSelection(Player player, int id, int scroll) {
        SkillListMenu.setSelection((Player)player, (int)(id | scroll << 8));
    }

    private static ArrayList<PlayerSkill> getSkills(Player player) {
        Object list = SkillListMenu.getData((Player)player, (String)AVAILABLE);
        return list == null ? null : (ArrayList)list;
    }

    private void move(Player player, int i) {
        int id = SkillListMenu.getId(player);
        int scroll = SkillListMenu.getScroll(player);
        int skills = SkillListMenu.getSkills(player).size();
        if ((id += i) < 0) {
            id = 0;
            scroll = 0;
        }
        if (id >= skills) {
            id = skills - 1;
            scroll = id - 3;
        }
        while (id - scroll <= 0 && id > 0) {
            --scroll;
        }
        while (id - scroll >= 3 && id < skills - 1) {
            ++scroll;
        }
        SkillListMenu.setSelection(player, id, scroll);
        SkillListMenu.setData((Player)player, (String)SELECTION, (Object)id);
    }

    public void onUp(Player player) {
        this.move(player, -1);
    }

    public void onDown(Player player) {
        this.move(player, 1);
    }

    public void onLeft(Player player) {
        this.move(player, -4);
    }

    public void onRight(Player player) {
        this.move(player, 4);
    }

    public void onSelect(Player player) {
        MapMenuManager.sendNext((Player)player, (MapMenu)Menu.DETAIL_MENU);
    }

    public void setup(Player player) {
        MapScheme scheme = MapScheme.get((JavaPlugin)this.api, (String)SkillAPI.getPlayerData((OfflinePlayer)player).getScheme());
        MapScene scene = SkillListMenu.getScene((Player)player);
        PlayerData playerData = SkillAPI.getPlayerData((OfflinePlayer)player);
        ArrayList<PlayerSkill> skills = new ArrayList<PlayerSkill>();
        for (PlayerSkill skill : playerData.getSkills()) {
            if (!skill.getPlayerClass().getData().getSkillTree().canShow(player, skill.getData())) continue;
            int id = skills.size();
            skills.add(skill);
            scene.add(PLATE + id, new MapObject(scheme.getImage("nameplate"), 0, 0));
            scene.add(NAME + id, new MapObject((MapImage)new MapString(scheme.getFont("list"), scheme.getColor("font"), skill.getData().getName()), 0, 0));
        }
        scene.add(SELECTOR, new MapObject(scheme.getImage(SELECTOR), 0, 0));
        scene.add(TITLE, new MapObject(scheme.getImage(TITLE), 0, 0));
        SkillListMenu.setSelection((Player)player, (int)0);
        SkillListMenu.setData((Player)player, (String)AVAILABLE, skills);
        SkillListMenu.setData((Player)player, (String)SELECTION, (Object)0);
    }

    public void render(MapBuffer mapBuffer, Player player) {
        MapScene scene = SkillListMenu.getScene((Player)player);
        int id = SkillListMenu.getId(player);
        int scroll = SkillListMenu.getScroll(player);
        ArrayList<PlayerSkill> skills = SkillListMenu.getSkills(player);
        for (int i = Math.max(0, scroll - 1); i < scroll + 6 && i < skills.size(); ++i) {
            int y = (i - scroll) * 20 + 36;
            scene.get(PLATE + i).moveTo(0, y);
            if (id == i) {
                scene.get(SELECTOR).moveTo(6, y + 5);
            }
            scene.get(NAME + i).moveTo(30, y + 14);
        }
        scene.apply(mapBuffer);
    }
}

