/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.target;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.particle.ParticleHelper;
import com.sucy.skill.api.target.TargetHelper;
import com.sucy.skill.dynamic.ComponentType;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.EffectComponent;
import com.sucy.skill.dynamic.TempEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import org.bukkit.GameMode;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public abstract class TargetComponent
extends EffectComponent {
    private static final String ALLY = "group";
    private static final String WALL = "wall";
    private static final String CASTER = "caster";
    private static final String MAX = "max";
    boolean everyone;
    boolean allies;
    boolean throughWall;
    IncludeCaster self;

    @Override
    public ComponentType getType() {
        return ComponentType.TARGET;
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        List<LivingEntity> list = this.getTargets(caster, level, targets);
        return !list.isEmpty() && this.executeChildren(caster, level, list, force);
    }

    @Override
    public void load(DynamicSkill skill, DataSection config) {
        super.load(skill, config);
        String group = this.settings.getString(ALLY, "enemy").toLowerCase();
        this.everyone = group.equals("both");
        this.allies = group.equals("ally");
        this.throughWall = this.settings.getString(WALL, "false").equalsIgnoreCase("true");
        this.self = IncludeCaster.valueOf(this.settings.getString(CASTER, "false").toUpperCase().replace(' ', '_'));
    }

    abstract List<LivingEntity> getTargets(LivingEntity var1, int var2, List<LivingEntity> var3);

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, final int level, final List<LivingEntity> targets) {
        if (this.preview.getBool("per-target")) {
            BukkitTask task = new BukkitRunnable(){

                public void run() {
                    for (LivingEntity target : TargetComponent.this.getTargets((LivingEntity)caster, level, targets)) {
                        ParticleHelper.play(target.getLocation(), TargetComponent.this.preview, Set.of(caster), "per-target-", TargetComponent.this.preview.getBool("per-target-hitbox") ? target.getBoundingBox() : null);
                    }
                }
            }.runTaskTimer((Plugin)SkillAPI.inst(), 0L, (long)Math.max(1, this.preview.getInt("per-target-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
    }

    List<LivingEntity> determineTargets(LivingEntity caster, int level, List<LivingEntity> from, Function<LivingEntity, List<LivingEntity>> conversion) {
        double max = this.parseValues(caster, MAX, level, 99.0);
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        from.forEach(target -> {
            List found = (List)conversion.apply((LivingEntity)target);
            int count = 0;
            for (LivingEntity entity : found) {
                if ((double)count >= max) break;
                if (!this.isValidTarget(caster, (LivingEntity)target, entity) && (!this.self.equals((Object)IncludeCaster.IN_AREA) || caster != entity)) continue;
                list.add(entity);
                ++count;
            }
        });
        if (this.self.equals((Object)IncludeCaster.TRUE)) {
            list.add(caster);
        }
        return list;
    }

    boolean isValidTarget(LivingEntity caster, LivingEntity from, LivingEntity target) {
        if (SkillAPI.getMeta((Metadatable)target, "asMechanic") != null) {
            return false;
        }
        if (target instanceof TempEntity) {
            return true;
        }
        if (target instanceof Player && (((Player)target).getGameMode() == GameMode.SPECTATOR || ((Player)target).getGameMode() == GameMode.CREATIVE)) {
            return false;
        }
        return !(target == caster || !SkillAPI.getSettings().isValidTarget(target) || !this.throughWall && TargetHelper.isObstructed(from.getEyeLocation(), target.getEyeLocation()) || !this.everyone && this.allies != SkillAPI.getSettings().isAlly(caster, target));
    }

    public static enum IncludeCaster {
        TRUE,
        FALSE,
        IN_AREA;

    }
}

