/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.target;

import com.sucy.skill.api.util.Nearby;
import com.sucy.skill.cast.Preview;
import com.sucy.skill.dynamic.target.TargetComponent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class NearestTarget
extends TargetComponent {
    private static final String RADIUS = "radius";
    private Preview preview;
    private double radius = 0.0;

    @Override
    List<LivingEntity> getTargets(LivingEntity caster, int level, List<LivingEntity> targets) {
        double radius = this.parseValues(caster, RADIUS, level, 3.0);
        ArrayList<LivingEntity> result = new ArrayList<LivingEntity>();
        for (LivingEntity target : targets) {
            DistanceComparator comparator = new DistanceComparator(target.getLocation());
            Nearby.getLivingNearby((Entity)target, radius).stream().min(comparator).ifPresent(e -> {
                GameMode gm;
                GameMode gameMode = gm = e instanceof Player ? ((Player)e).getGameMode() : GameMode.SURVIVAL;
                if (gm == GameMode.SPECTATOR || gm == GameMode.CREATIVE) {
                    return;
                }
                result.add((LivingEntity)e);
            });
        }
        return result;
    }

    @Override
    public String getKey() {
        return "nearest";
    }

    private static class DistanceComparator
    implements Comparator<LivingEntity> {
        private Location loc;

        private DistanceComparator(Location loc) {
            this.loc = loc;
        }

        @Override
        public int compare(LivingEntity o1, LivingEntity o2) {
            return Double.compare(o1.getLocation().distanceSquared(this.loc), o2.getLocation().distanceSquared(this.loc));
        }
    }
}

