/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.target;

import com.sucy.skill.api.util.Nearby;
import com.sucy.skill.cast.RoundPreview;
import com.sucy.skill.dynamic.target.TargetComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class AreaTarget
extends TargetComponent {
    private static final String RADIUS = "radius";
    private static final String RANDOM = "random";
    private RoundPreview preview;
    private final Random random = new Random();

    @Override
    List<LivingEntity> getTargets(LivingEntity caster, int level, List<LivingEntity> targets) {
        double radius = this.parseValues(caster, RADIUS, level, 3.0);
        boolean random = this.settings.getBool(RANDOM, false);
        return this.determineTargets(caster, level, targets, t -> this.shuffle(Nearby.getLivingNearby((Entity)t, radius, true), random));
    }

    @Override
    public String getKey() {
        return "area";
    }

    private List<LivingEntity> shuffle(List<LivingEntity> targets, boolean random) {
        if (!random) {
            return targets;
        }
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        while (!targets.isEmpty()) {
            list.add(targets.remove(this.random.nextInt(targets.size())));
        }
        return list;
    }
}

