/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.particle.ParticleHelper;
import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.Nullable;

public class WarpValueMechanic
extends MechanicComponent {
    private static final String KEY = "key";

    @Override
    public String getKey() {
        return "warp value";
    }

    @Nullable
    private Location parseLocation(LivingEntity caster) {
        Map<String, Object> data = DynamicSkill.getCastData(caster);
        if (data == null) {
            return null;
        }
        String key = this.settings.getString(KEY);
        if (key == null) {
            return null;
        }
        Object obj = data.get(key);
        if (obj instanceof Location) {
            return (Location)obj;
        }
        return null;
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        Location loc = this.parseLocation(caster);
        if (loc == null) {
            return false;
        }
        for (LivingEntity target : targets) {
            target.teleport(loc);
        }
        return true;
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, int level, List<LivingEntity> targets) {
        if (this.preview.getBool("per-target")) {
            BukkitTask task = new BukkitRunnable(){

                public void run() {
                    Location loc = WarpValueMechanic.this.parseLocation((LivingEntity)caster);
                    if (loc == null) {
                        return;
                    }
                    ParticleHelper.play(loc, WarpValueMechanic.this.preview, Set.of(caster), "per-target-", null);
                }
            }.runTaskTimer((Plugin)SkillAPI.inst(), 0L, (long)Math.max(1, this.preview.getInt("per-target-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
    }
}

