/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.particle.ParticleHelper;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.Nullable;

public class WarpLocMechanic
extends MechanicComponent {
    private static final String WORLD = "world";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String Z = "z";
    private static final String YAW = "yaw";
    private static final String PITCH = "pitch";

    @Override
    public String getKey() {
        return "warp location";
    }

    @Nullable
    private Location parseLocation(LivingEntity caster) {
        World w;
        String world = this.settings.getString(WORLD, "current");
        if (world.equalsIgnoreCase("current")) {
            world = caster.getWorld().getName();
        }
        if ((w = Bukkit.getWorld((String)world)) == null) {
            return null;
        }
        double x = this.settings.getDouble(X, 0.0);
        double y = this.settings.getDouble(Y, 0.0);
        double z = this.settings.getDouble(Z, 0.0);
        float yaw = (float)this.settings.getDouble(YAW, 0.0);
        float pitch = (float)this.settings.getDouble(PITCH, 0.0);
        return new Location(w, x, y, z, yaw, pitch);
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        Location loc = this.parseLocation(caster);
        if (loc == null) {
            return false;
        }
        for (LivingEntity target : targets) {
            target.teleport(loc);
        }
        return true;
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, int level, List<LivingEntity> targets) {
        if (this.preview.getBool("per-target") && !targets.isEmpty()) {
            BukkitTask task = new BukkitRunnable(){

                public void run() {
                    Location loc = WarpLocMechanic.this.parseLocation((LivingEntity)caster);
                    if (loc == null) {
                        return;
                    }
                    ParticleHelper.play(loc, WarpLocMechanic.this.preview, Set.of(caster), "per-target-", null);
                }
            }.runTaskTimer((Plugin)SkillAPI.inst(), 0L, (long)Math.max(1, this.preview.getInt("per-target-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
    }
}

