/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import com.sucy.skill.hook.PlaceholderAPIHook;
import com.sucy.skill.hook.PluginChecker;
import com.sucy.skill.log.Logger;
import java.util.List;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ValuePlaceholderMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String TYPE = "type";
    private static final String PLACEHOLDER = "placeholder";

    @Override
    public String getKey() {
        return "value placeholder";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (!PluginChecker.isPlaceholderAPIActive()) {
            return false;
        }
        if (targets.get(0) instanceof Player) {
            String key = this.settings.getString(KEY);
            String placeholder = this.settings.getString(PLACEHOLDER);
            String type = this.settings.getString(TYPE).toUpperCase();
            String value = PlaceholderAPIHook.format(placeholder, (Player)targets.get(0));
            switch (type.charAt(0)) {
                case 'S': {
                    DynamicSkill.getCastData(caster).put(key, value);
                    break;
                }
                default: {
                    try {
                        DynamicSkill.getCastData(caster).put(key, Double.parseDouble(value));
                        break;
                    }
                    catch (Exception ex) {
                        Logger.invalid(placeholder + " is not a valid numeric placeholder - PlaceholderAPI returned " + value);
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }
}

