/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import org.bukkit.entity.LivingEntity;

public class ValueCopyMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String TARGET = "destination";
    private static final String TO_TARGET = "to-target";

    @Override
    public String getKey() {
        return "value copy";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0 || !this.settings.has(KEY)) {
            return false;
        }
        String key = this.settings.getString(KEY);
        String destination = this.settings.getString(TARGET, key);
        boolean toTarget = this.settings.getString(TO_TARGET, "true").equalsIgnoreCase("true");
        if (toTarget) {
            targets.forEach(target -> this.apply(caster, (LivingEntity)target, key, destination));
        } else {
            this.apply(targets.get(0), caster, key, destination);
        }
        return true;
    }

    private boolean apply(LivingEntity from, LivingEntity to, String key, String destination) {
        Object value = DynamicSkill.getCastData(from).get(key);
        if (value == null) {
            return false;
        }
        DynamicSkill.getCastData(to).put(destination, value);
        return true;
    }
}

