/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.api.skills.SkillShot;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class SkillCastMechanic
extends MechanicComponent {
    @Override
    public String getKey() {
        return "skill cast";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        String mode = this.settings.getString("mode", "first").toLowerCase();
        boolean force_cast = this.settings.getBool("force", false);
        List<String> skills = this.settings.getStringList("skills");
        targets.forEach(target -> {
            if (!(target instanceof Player)) {
                return;
            }
            Player player = (Player)target;
            PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)player);
            ArrayList handle = new ArrayList();
            skills.forEach(s -> {
                String[] split = s.split(":", 2);
                handle.add(new AbstractMap.SimpleEntry<String, Integer>(split[0], SkillCastMechanic.parseInt(split.length > 1 ? split[1] : null)));
            });
            List filtered = handle.stream().filter(e -> SkillAPI.getSkill((String)e.getKey()) != null && SkillAPI.getSkill((String)e.getKey()) instanceof SkillShot && (force_cast || data.hasSkill((String)e.getKey()) && data.getSkill((String)e.getKey()).getLevel() > 0)).collect(Collectors.toList());
            if (filtered.isEmpty()) {
                return;
            }
            switch (mode) {
                case "first": {
                    SkillCastMechanic.cast(player, (String)((Map.Entry)filtered.get(0)).getKey(), (Integer)((Map.Entry)filtered.get(0)).getValue(), force_cast);
                    break;
                }
                case "all": {
                    handle.forEach(entry -> SkillCastMechanic.cast(player, (String)entry.getKey(), (Integer)entry.getValue(), force_cast));
                    break;
                }
                case "random": {
                    int i = new Random().nextInt(filtered.size());
                    SkillCastMechanic.cast(player, (String)((Map.Entry)filtered.get(i)).getKey(), (Integer)((Map.Entry)filtered.get(i)).getValue(), force_cast);
                }
            }
        });
        return true;
    }

    private static int parseInt(String input) {
        try {
            return Integer.parseInt(input);
        }
        catch (NullPointerException | NumberFormatException e) {
            return -1;
        }
    }

    private static void cast(Player player, String sk, int lv, boolean force) {
        PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)player);
        if (lv <= 0) {
            lv = data.hasSkill(sk) && data.getSkill(sk).getLevel() > 0 ? data.getSkill(sk).getLevel() : 1;
        }
        Skill skill = SkillAPI.getSkill(sk);
        ((SkillShot)((Object)skill)).cast((LivingEntity)player, lv, force);
    }
}

