/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.dynamic.TempEntity;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mc.promcteam.engine.mccore.util.VersionManager;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.metadata.Metadatable;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionType;

public class PotionProjectileMechanic
extends MechanicComponent {
    private static final String POTION = "type";
    private static final String ALLY = "group";
    private static final String LINGER = "linger";
    private static final String COLOR = "color";

    @Override
    public String getKey() {
        return "potion projectile";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        ItemStack item;
        PotionType type;
        String potion = this.settings.getString(POTION, "slowness").toUpperCase().replace(" ", "_");
        String color = this.settings.getString(COLOR);
        boolean linger = this.settings.getString(LINGER, "false").equalsIgnoreCase("true") && VersionManager.isVersionAtLeast((int)VersionManager.V1_9_0);
        try {
            type = PotionType.valueOf((String)potion);
        }
        catch (Exception ex) {
            type = PotionType.SLOWNESS;
        }
        Potion p = new Potion(type, 1);
        try {
            item = new ItemStack(Material.valueOf((String)(linger ? "LINGERING_POTION" : "SPLASH_POTION")));
            Field meta = ItemStack.class.getDeclaredField("meta");
            meta.setAccessible(true);
            PotionMeta potionMeta = (PotionMeta)item.getItemMeta();
            if (color != null) {
                potionMeta.setColor(Color.fromRGB((int)Integer.parseInt(color.substring(1), 16)));
            }
            potionMeta.setDisplayName("lol");
            meta.set(item, potionMeta);
        }
        catch (Exception ex) {
            item = new ItemStack(Material.POTION);
        }
        p.apply(item);
        for (LivingEntity target : targets) {
            ThrownPotion thrown = (ThrownPotion)target.launchProjectile(linger ? LingeringPotion.class : ThrownPotion.class);
            SkillAPI.setMeta((Metadatable)thrown, "skill_level", level);
            SkillAPI.setMeta((Metadatable)thrown, "caster", caster);
            SkillAPI.setMeta((Metadatable)thrown, "potionProjectile", this);
            thrown.setItem(item);
        }
        return targets.size() > 0;
    }

    public void callback(Entity entity, Collection<LivingEntity> hit) {
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>(hit);
        String group = this.settings.getString(ALLY, "enemy").toLowerCase();
        boolean both = group.equals("both");
        boolean ally = group.equals("ally");
        LivingEntity caster = (LivingEntity)SkillAPI.getMeta((Metadatable)entity, "caster");
        int level = SkillAPI.getMetaInt((Metadatable)entity, "skill_level");
        Location loc = entity.getLocation();
        for (int i = 0; i < targets.size(); ++i) {
            if (both || SkillAPI.getSettings().canAttack(caster, (LivingEntity)targets.get(i)) != ally) continue;
            targets.remove(i);
            --i;
        }
        if (targets.size() == 0) {
            TempEntity locTarget = new TempEntity(loc);
            targets.add(locTarget);
        }
        this.executeChildren(caster, level, targets, this.skill.isForced(caster));
    }
}

