/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.Settings;
import com.sucy.skill.api.particle.EffectPlayer;
import com.sucy.skill.api.particle.target.FollowTarget;
import com.sucy.skill.api.projectile.CustomProjectile;
import com.sucy.skill.api.projectile.ParticleProjectile;
import com.sucy.skill.api.projectile.ProjectileCallback;
import com.sucy.skill.cast.Preview;
import com.sucy.skill.dynamic.TempEntity;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class ParticleProjectileMechanic
extends MechanicComponent
implements ProjectileCallback {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final String GROUP = "group";
    private static final String VELOCITY = "velocity";
    private static final String LIFESPAN = "lifespan";
    private static final String SPREAD = "spread";
    private static final String AMOUNT = "amount";
    private static final String ANGLE = "angle";
    private static final String HEIGHT = "height";
    private static final String RADIUS = "rain-radius";
    private static final String LEVEL = "skill_level";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";
    private static final String USE_EFFECT = "use-effect";
    private static final String EFFECT_KEY = "effect-key";
    private Preview preview;

    @Override
    public String getKey() {
        return "particle projectile";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        int amount = (int)this.parseValues(caster, AMOUNT, level, 1.0);
        String spread = this.settings.getString(SPREAD, "cone").toLowerCase();
        boolean ally = this.settings.getString(GROUP, "enemy").equalsIgnoreCase("ally");
        this.settings.set("level", level);
        int life = (int)(this.parseValues(caster, LIFESPAN, level, this.settings.getDouble(LIFESPAN, 2.0)) * 20.0);
        Settings copy = new Settings(this.settings);
        copy.set(VELOCITY, this.parseValues(caster, VELOCITY, level, 1.0), 0.0);
        copy.set("particles", this.parseValues(caster, "particles", level, 1.0), 0.0);
        copy.set("radius", this.parseValues(caster, "radius", level, 0.0), 0.0);
        for (LivingEntity target : targets) {
            ArrayList<ParticleProjectile> list;
            Location loc = target.getLocation();
            if (spread.equals("rain")) {
                double radius = this.parseValues(caster, RADIUS, level, 2.0);
                double d = this.parseValues(caster, HEIGHT, level, 8.0);
                list = ParticleProjectile.rain(caster, level, loc, copy, radius, d, amount, this, life);
            } else {
                Vector dir = target.getLocation().getDirection();
                double right = this.parseValues(caster, RIGHT, level, 0.0);
                double upward = this.parseValues(caster, UPWARD, level, 0.0);
                double forward = this.parseValues(caster, FORWARD, level, 0.0);
                Vector looking = dir.clone().setY(0).normalize();
                Vector normal = looking.clone().crossProduct(UP);
                looking.multiply(forward).add(normal.multiply(right));
                if (spread.equals("horizontal cone")) {
                    dir.setY(0);
                    dir.normalize();
                }
                double angle = this.parseValues(caster, ANGLE, level, 30.0);
                list = ParticleProjectile.spread(caster, level, dir, loc.add(looking).add(0.0, upward + 0.5, 0.0), copy, angle, amount, this, life);
            }
            for (ParticleProjectile p : list) {
                SkillAPI.setMeta(p, LEVEL, level);
                p.setAllyEnemy(ally, !ally);
            }
            if (!this.settings.getBool(USE_EFFECT, false)) continue;
            EffectPlayer player = new EffectPlayer(this.settings);
            for (CustomProjectile customProjectile : list) {
                player.start(new FollowTarget(customProjectile), this.settings.getString(EFFECT_KEY, this.skill.getName()), life, level, true);
            }
        }
        return targets.size() > 0;
    }

    @Override
    public void callback(CustomProjectile projectile, LivingEntity hit) {
        if (hit == null) {
            hit = new TempEntity(projectile.getLocation());
        }
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        targets.add(hit);
        this.executeChildren(projectile.getShooter(), SkillAPI.getMetaInt(projectile, LEVEL), targets, this.skill.isForced(projectile.getShooter()));
    }
}

