/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.Settings;
import com.sucy.skill.api.particle.ParticleHelper;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ParticleAnimationMechanic
extends MechanicComponent {
    public static final String WITH_ROTATION = "-with-rotation";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";
    private static final String STEPS = "steps";
    private static final String FREQ = "frequency";
    private static final String ANGLE = "angle";
    private static final String START = "start";
    private static final String DURATION = "duration";
    private static final String H_TRANS = "h-translation";
    private static final String V_TRANS = "v-translation";
    private static final String H_CYCLES = "h-cycles";
    private static final String V_CYCLES = "v-cycles";

    @Override
    public String getKey() {
        return "particle animation";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0) {
            return false;
        }
        Settings copy = new Settings(this.settings);
        copy.set("particles", this.parseValues(caster, "particles", level, 1.0), 0.0);
        copy.set("radius", this.parseValues(caster, "radius", level, 0.0), 0.0);
        copy.set("level", level);
        new ParticleTask(caster, targets, level, copy);
        return targets.size() > 0;
    }

    private class ParticleTask
    extends BukkitRunnable {
        private final List<LivingEntity> targets;
        private final double[] rots;
        private final Vector offset;
        private final Vector dir;
        private final double forward;
        private final double right;
        private final double upward;
        private final int steps;
        private final int freq;
        private final int angle;
        private final int startAngle;
        private final int duration;
        private final int hc;
        private final int vc;
        private final int hl;
        private final int vl;
        private final double ht;
        private final double vt;
        private final double cos;
        private final Settings settings;
        private final double sin;
        private int life;
        private boolean withRotation = false;

        ParticleTask(LivingEntity caster, List<LivingEntity> targets, int level, Settings settings) {
            this.targets = targets;
            this.settings = settings;
            this.forward = settings.getDouble(ParticleAnimationMechanic.FORWARD, 0.0);
            this.upward = settings.getDouble(ParticleAnimationMechanic.UPWARD, 0.0);
            this.right = settings.getDouble(ParticleAnimationMechanic.RIGHT, 0.0);
            this.steps = settings.getInt(ParticleAnimationMechanic.STEPS, 1);
            this.freq = (int)(settings.getDouble(ParticleAnimationMechanic.FREQ, 1.0) * 20.0);
            this.angle = settings.getInt(ParticleAnimationMechanic.ANGLE, 0);
            this.startAngle = settings.getInt(ParticleAnimationMechanic.START, 0);
            this.duration = this.steps * (int)(20.0 * ParticleAnimationMechanic.this.parseValues(caster, ParticleAnimationMechanic.DURATION, level, 3.0));
            this.life = 0;
            this.ht = ParticleAnimationMechanic.this.parseValues(caster, ParticleAnimationMechanic.H_TRANS, level, 0.0);
            this.vt = ParticleAnimationMechanic.this.parseValues(caster, ParticleAnimationMechanic.V_TRANS, level, 0.0);
            this.hc = settings.getInt(ParticleAnimationMechanic.H_CYCLES, 1);
            this.vc = settings.getInt(ParticleAnimationMechanic.V_CYCLES, 1);
            this.hl = this.duration / this.hc;
            this.vl = this.duration / this.vc;
            this.withRotation = settings.getBool(ParticleAnimationMechanic.WITH_ROTATION);
            this.cos = Math.cos((double)this.angle * Math.PI / (double)(180 * this.duration));
            this.sin = Math.sin((double)this.angle * Math.PI / (double)(180 * this.duration));
            this.rots = new double[targets.size()];
            for (int i = 0; i < targets.size(); ++i) {
                this.rots[i] = targets.get(i).getLocation().getYaw();
            }
            this.dir = new Vector(0, 0, 1);
            this.offset = new Vector(this.right, this.upward, this.forward);
            double sc = Math.cos(Math.toRadians(this.startAngle));
            double ss = Math.sin(Math.toRadians(this.startAngle));
            this.rotate(this.offset, sc, ss);
            this.rotate(this.dir, sc, ss);
            SkillAPI.schedule(this, 0, this.freq);
        }

        public void run() {
            for (int i = 0; i < this.steps; ++i) {
                int j = 0;
                for (LivingEntity target : this.targets) {
                    Location loc = target.getLocation();
                    double targetAngle = loc.getYaw();
                    if (this.withRotation) {
                        double targetCos = Math.cos(Math.toRadians(targetAngle));
                        double targetSin = Math.sin(Math.toRadians(targetAngle));
                        this.rotate(this.offset, targetCos, targetSin);
                        loc.add(this.offset);
                        ParticleHelper.play(loc, this.settings);
                        loc.subtract(this.offset);
                        targetCos = Math.cos(Math.toRadians(-targetAngle));
                        targetSin = Math.sin(Math.toRadians(-targetAngle));
                        this.rotate(this.offset, targetCos, targetSin);
                        continue;
                    }
                    this.rotate(this.offset, Math.cos(Math.toRadians(this.rots[j])), Math.sin(Math.toRadians(this.rots[j])));
                    loc.add(this.offset);
                    ParticleHelper.play(loc, this.settings);
                    loc.subtract(this.offset);
                    this.rotate(this.offset, Math.cos(Math.toRadians(-this.rots[j])), Math.sin(Math.toRadians(-this.rots[j])));
                    ++j;
                }
                ++this.life;
                this.rotate(this.offset, this.cos, this.sin);
                this.rotate(this.dir, this.cos, this.sin);
                double dx = this.radAt(this.life) - this.radAt(this.life - 1);
                this.offset.setX(this.offset.getX() + dx * this.dir.getX());
                this.offset.setZ(this.offset.getZ() + dx * this.dir.getZ());
                this.offset.setY(this.upward + this.heightAt(this.life));
            }
            if (this.life >= this.duration) {
                this.cancel();
            }
        }

        private double heightAt(int step) {
            return this.vt * (double)(this.vl - Math.abs(this.vl - step % (2 * this.vl))) / (double)this.vl;
        }

        private double radAt(int step) {
            return this.ht * (double)(this.hl - Math.abs(this.hl - step % (2 * this.hl))) / (double)this.hl;
        }

        private void rotate(Vector vec, double cos, double sin) {
            double x = vec.getX() * cos - vec.getZ() * sin;
            vec.setZ(vec.getX() * sin + vec.getZ() * cos);
            vec.setX(x);
        }
    }
}

