/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.enums.ManaCost;
import com.sucy.skill.api.enums.ManaSource;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ManaMechanic
extends MechanicComponent {
    private static final String TYPE = "type";
    private static final String VALUE = "value";

    @Override
    public String getKey() {
        return "mana";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        boolean percent = this.settings.getString(TYPE, "mana").toLowerCase().equals("percent");
        double value = this.parseValues(caster, VALUE, level, 1.0);
        boolean worked = false;
        for (LivingEntity target : targets) {
            if (!(target instanceof Player)) continue;
            worked = true;
            PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)((Player)target));
            double amount = percent ? data.getMaxMana() * value / 100.0 : value;
            if (amount > 0.0) {
                data.giveMana(amount, ManaSource.SKILL);
                continue;
            }
            data.useMana(-amount, ManaCost.SKILL_EFFECT);
        }
        return worked;
    }
}

