/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.Settings;
import com.sucy.skill.api.particle.EffectPlayer;
import com.sucy.skill.api.particle.target.FollowTarget;
import com.sucy.skill.api.projectile.CustomProjectile;
import com.sucy.skill.api.projectile.ItemProjectile;
import com.sucy.skill.api.projectile.ProjectileCallback;
import com.sucy.skill.api.util.ItemStackReader;
import com.sucy.skill.cast.Preview;
import com.sucy.skill.dynamic.TempEntity;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ItemProjectileMechanic
extends MechanicComponent
implements ProjectileCallback {
    private static final Vector UP = new Vector(0, 1, 0);
    private static final String ALLY = "group";
    private static final String WALLS = "walls";
    private static final String VELOCITY = "velocity";
    private static final String LIFESPAN = "lifespan";
    private static final String SPREAD = "spread";
    private static final String AMOUNT = "amount";
    private static final String ANGLE = "angle";
    private static final String HEIGHT = "height";
    private static final String RADIUS = "rain-radius";
    private static final String LEVEL = "skill_level";
    private static final String FORWARD = "forward";
    private static final String UPWARD = "upward";
    private static final String RIGHT = "right";
    private static final String USE_EFFECT = "use-effect";
    private static final String EFFECT_KEY = "effect-key";
    private Preview preview;

    @Override
    public String getKey() {
        return "item projectile";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        ItemStack item = ItemStackReader.read(this.settings);
        double speed = this.parseValues(caster, VELOCITY, level, 3.0);
        int amount = (int)this.parseValues(caster, AMOUNT, level, 1.0);
        String spread = this.settings.getString(SPREAD, "cone").toLowerCase();
        boolean ally = this.settings.getString(ALLY, "enemy").equalsIgnoreCase("ally");
        boolean walls = this.settings.getBool(WALLS, false);
        int lifespan = (int)(this.parseValues(caster, LIFESPAN, level, 9999.0) * 20.0);
        Settings copy = new Settings(this.settings);
        copy.set(VELOCITY, this.parseValues(caster, VELOCITY, level, 1.0), 0.0);
        copy.set("particles", this.parseValues(caster, "particles", level, 1.0), 0.0);
        copy.set("radius", this.parseValues(caster, "radius", level, 0.0), 0.0);
        for (LivingEntity target : targets) {
            ArrayList<ItemProjectile> list;
            Location loc = target.getLocation();
            if (spread.equals("rain")) {
                double radius = this.parseValues(caster, RADIUS, level, 2.0);
                double d = this.parseValues(caster, HEIGHT, level, 8.0);
                list = ItemProjectile.rain(caster, loc, copy, item, radius, d, speed, amount, this, lifespan, walls);
            } else {
                Vector dir = target.getLocation().getDirection();
                double right = this.parseValues(caster, RIGHT, level, 0.0);
                double upward = this.parseValues(caster, UPWARD, level, 0.0);
                double forward = this.parseValues(caster, FORWARD, level, 0.0);
                Vector looking = dir.clone().setY(0).normalize();
                Vector normal = looking.clone().crossProduct(UP);
                looking.multiply(forward).add(normal.multiply(right));
                if (spread.equals("horizontal cone")) {
                    dir.setY(0);
                    dir.normalize();
                }
                dir.multiply(speed);
                double angle = this.parseValues(caster, ANGLE, level, 30.0);
                list = ItemProjectile.spread(caster, dir, loc.add(looking).add(0.0, 0.5 + upward, 0.0), copy, item, angle, amount, this, lifespan, walls);
            }
            for (ItemProjectile p : list) {
                SkillAPI.setMeta(p, LEVEL, level);
                p.setAllyEnemy(ally, !ally);
            }
            if (!this.settings.getBool(USE_EFFECT, false)) continue;
            EffectPlayer player = new EffectPlayer(this.settings);
            for (CustomProjectile customProjectile : list) {
                player.start(new FollowTarget(customProjectile), this.settings.getString(EFFECT_KEY, this.skill.getName()), 9999, level, true);
            }
        }
        return targets.size() > 0;
    }

    @Override
    public void callback(CustomProjectile projectile, LivingEntity hit) {
        if (hit == null) {
            hit = new TempEntity(projectile.getLocation());
        }
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        targets.add(hit);
        this.executeChildren(projectile.getShooter(), SkillAPI.getMetaInt(projectile, LEVEL), targets, this.skill.isForced(projectile.getShooter()));
        projectile.setCallback(null);
    }
}

