/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.api.util.FlagManager;
import com.sucy.skill.dynamic.TempEntity;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import com.sucy.skill.hook.DisguiseHook;
import com.sucy.skill.hook.PluginChecker;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;

public class DisguiseMechanic
extends MechanicComponent {
    private static final String TYPE = "type";
    private static final String MOB = "mob";
    private static final String ADULT = "adult";
    private static final String PLAYER = "player";
    private static final String MISC = "misc";
    private static final String DATA = "data";
    private static final String MATERIAL = "mat";
    private static final String DURATION = "duration";

    @Override
    public String getKey() {
        return "disguise";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (!PluginChecker.isDisguiseActive()) {
            return false;
        }
        String type = this.settings.getString(TYPE);
        if (type.equalsIgnoreCase(MOB)) {
            for (LivingEntity target : targets) {
                if (target instanceof TempEntity) continue;
                DisguiseHook.disguiseMob(target, this.settings.getString(MOB, "Zombie"), this.settings.getBool(ADULT, true));
            }
        } else if (type.equalsIgnoreCase(PLAYER)) {
            for (LivingEntity target : targets) {
                if (target instanceof TempEntity) continue;
                DisguiseHook.disguisePlayer(target, this.settings.getString(PLAYER, "Eniripsa96").replace("{player}", caster.getName()));
            }
        } else if (type.equalsIgnoreCase(MISC)) {
            for (LivingEntity target : targets) {
                if (target instanceof TempEntity) continue;
                String dataType = this.settings.getString(MISC, "Painting");
                if (dataType.equals("Dropped Item") || dataType.equals("Falling Block")) {
                    DisguiseHook.disguiseMisc(target, dataType, Material.valueOf((String)this.settings.getString(MATERIAL, "Anvil").toUpperCase().replace(" ", "_")));
                    continue;
                }
                DisguiseHook.disguiseMisc(target, dataType, this.settings.getInt(DATA, 0));
            }
        } else {
            return false;
        }
        int ticks = (int)(this.parseValues(caster, DURATION, level, -1.0) * 20.0);
        for (LivingEntity target : targets) {
            if (target instanceof TempEntity) continue;
            FlagManager.addFlag(target, "sapiDisguiseKey", ticks);
        }
        return targets.size() > 0;
    }
}

