/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.api.util.Buff;
import com.sucy.skill.api.util.BuffManager;
import com.sucy.skill.api.util.BuffType;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.List;
import org.bukkit.entity.LivingEntity;

public class DamageBuffMechanic
extends MechanicComponent {
    private static final String TYPE = "type";
    private static final String SKILL = "skill";
    private static final String VALUE = "value";
    private static final String SECONDS = "seconds";

    @Override
    public String getKey() {
        return "damage buff";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() == 0) {
            return false;
        }
        boolean skill = this.settings.getString(SKILL, "false").equalsIgnoreCase("true");
        boolean percent = this.settings.getString(TYPE, "flat").toLowerCase().equals("multiplier");
        double value = this.parseValues(caster, VALUE, level, 1.0);
        double seconds = this.parseValues(caster, SECONDS, level, 3.0);
        int ticks = (int)(seconds * 20.0);
        for (LivingEntity target : targets) {
            BuffManager.addBuff(target, skill ? BuffType.SKILL_DAMAGE : BuffType.DAMAGE, new Buff(this.skill.getName(), value, percent), ticks);
        }
        return targets.size() > 0;
    }
}

