/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.google.common.collect.ImmutableSet;
import com.sucy.skill.api.util.FlagManager;
import com.sucy.skill.api.util.StatusFlag;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffectType;

public class CleanseMechanic
extends MechanicComponent {
    private static final Set<PotionEffectType> POTIONS = ImmutableSet.of((Object)PotionEffectType.BLINDNESS, (Object)PotionEffectType.CONFUSION, (Object)PotionEffectType.HUNGER, (Object)PotionEffectType.LEVITATION, (Object)PotionEffectType.POISON, (Object)PotionEffectType.SLOW, (Object[])new PotionEffectType[]{PotionEffectType.SLOW_DIGGING, PotionEffectType.WEAKNESS, PotionEffectType.WITHER});
    private static final String STATUS = "status";
    private static final String POTION = "potion";

    @Override
    public String getKey() {
        return "cleanse";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        boolean worked = false;
        HashSet<String> statusSet = new HashSet<String>();
        for (String string : this.settings.getStringList(STATUS)) {
            if (string.equalsIgnoreCase("All")) {
                for (String status : StatusFlag.NEGATIVE) {
                    statusSet.add(status);
                }
                break;
            }
            statusSet.add(string.toLowerCase());
        }
        HashSet<PotionEffectType> potionSet = new HashSet<PotionEffectType>();
        for (String string : this.settings.getStringList(POTION)) {
            if (string.equalsIgnoreCase("All")) {
                potionSet.addAll(POTIONS);
                break;
            }
            try {
                potionSet.add(Objects.requireNonNull(PotionEffectType.getByName((String)string.toLowerCase().replace(' ', '_'))));
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {}
        }
        for (LivingEntity target : targets) {
            for (String status : statusSet) {
                if (!FlagManager.hasFlag(target, status)) continue;
                FlagManager.removeFlag(target, status);
                worked = true;
            }
            for (PotionEffectType type : potionSet) {
                if (!target.hasPotionEffect(type)) continue;
                target.removePotionEffect(type);
                worked = true;
            }
        }
        return worked;
    }
}

