/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.mechanic;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.enums.Operation;
import com.sucy.skill.api.player.PlayerAttributeModifier;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.dynamic.mechanic.MechanicComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AttributeMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String OPERATION = "operation";
    private static final String AMOUNT = "amount";
    private static final String SECONDS = "seconds";
    private static final String STACKABLE = "stackable";
    private final Map<Integer, Map<String, AttribTask>> tasks = new HashMap<Integer, Map<String, AttribTask>>();

    @Override
    public String getKey() {
        return "attribute";
    }

    @Override
    protected void doCleanUp(LivingEntity user) {
        Map<String, AttribTask> casterTasks = this.tasks.remove(user.getEntityId());
        if (casterTasks != null) {
            casterTasks.values().forEach(AttribTask::stop);
        }
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        String key = this.settings.getString(KEY, "");
        if (targets.size() == 0 || SkillAPI.getAttributeManager().getAttribute(key) == null) {
            return false;
        }
        Map casterTasks = this.tasks.computeIfAbsent(caster.getEntityId(), HashMap::new);
        int amount = (int)this.parseValues(caster, AMOUNT, level, 5.0);
        double seconds = this.parseValues(caster, SECONDS, level, 3.0);
        boolean stackable = this.settings.getString(STACKABLE, "false").equalsIgnoreCase("true");
        int ticks = (int)(seconds * 20.0);
        String operation = this.settings.getString(OPERATION, "MULTIPLY_PERCENTAGE");
        boolean worked = false;
        for (LivingEntity target : targets) {
            if (!(target instanceof Player)) continue;
            worked = true;
            PlayerData data = SkillAPI.getPlayerData((OfflinePlayer)((Player)target));
            PlayerAttributeModifier modifier = new PlayerAttributeModifier("skillapi.mechanic.attribute_mechanic", amount, Operation.valueOf(operation), false);
            if (casterTasks.containsKey(data.getPlayerName()) && !stackable) {
                AttribTask old = (AttribTask)((Object)casterTasks.remove(data.getPlayerName()));
                data.removeAttributeModifier(old.modifier.getUUID(), false);
                data.addAttributeModifier(key, modifier, true);
                old.cancel();
            } else {
                data.addAttributeModifier(key, modifier, true);
            }
            AttribTask task = new AttribTask(caster.getEntityId(), data, modifier);
            casterTasks.put(data.getPlayerName(), task);
            if (ticks < 0) continue;
            SkillAPI.schedule(task, ticks);
        }
        return worked;
    }

    private class AttribTask
    extends BukkitRunnable {
        private final PlayerData data;
        private final PlayerAttributeModifier modifier;
        private final int id;
        private boolean running = false;
        private boolean stopped = false;

        AttribTask(int id, PlayerData data, PlayerAttributeModifier modifier) {
            this.id = id;
            this.data = data;
            this.modifier = modifier;
        }

        public void stop() {
            if (!this.stopped) {
                this.stopped = true;
                this.run();
                if (this.running) {
                    this.cancel();
                }
            }
        }

        public BukkitTask runTaskLater(Plugin plugin, long delay) {
            this.running = true;
            return super.runTaskLater(plugin, delay);
        }

        public void run() {
            this.data.removeAttributeModifier(this.modifier.getUUID(), true);
            if (AttributeMechanic.this.tasks.containsKey(this.id)) {
                AttributeMechanic.this.tasks.get(this.id).remove(this.data.getPlayerName());
            }
            this.running = false;
        }
    }
}

