/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.condition;

import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.condition.ConditionComponent;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import org.bukkit.entity.LivingEntity;

public class ValueTextCondition
extends ConditionComponent {
    private static final String MODE = "mode";
    private static final String VALUE = "value";
    private static final String EXPECT = "expect";

    @Override
    public String getKey() {
        return "valuetext";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        return this.test(caster, level, null) && this.executeChildren(caster, level, targets, force);
    }

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        CompareMode mode = CompareMode.valueOf(this.settings.getString(MODE).toUpperCase());
        Object value = DynamicSkill.getCastData(caster).get(this.settings.getString(VALUE));
        String expect = this.settings.getString(EXPECT);
        if (value == null || expect == null) {
            return false;
        }
        return mode.compare((String)value, expect);
    }

    private static enum CompareMode {
        REGEX((r, c) -> Pattern.compile(c).matcher((CharSequence)r).find()),
        EXACTLY(Objects::equals),
        CONTAIN(String::contains),
        START(String::startsWith),
        END(String::endsWith);

        private final BiPredicate<String, String> consumer;

        private CompareMode(BiPredicate<String, String> consumer) {
            this.consumer = consumer;
        }

        public boolean compare(String raw, String con) {
            return this.consumer.test(raw, con);
        }
    }
}

