/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.dynamic.condition;

import com.sucy.skill.dynamic.DynamicSkill;
import com.sucy.skill.dynamic.condition.ConditionComponent;
import java.util.Set;
import java.util.stream.Collectors;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;

public class BlockCondition
extends ConditionComponent {
    private static final String MATERIAL = "material";
    private static final String STANDING = "standing";
    private Set<String> types;
    private boolean negated;
    private boolean in;

    @Override
    public String getKey() {
        return "block";
    }

    @Override
    public void load(DynamicSkill skill, DataSection config) {
        super.load(skill, config);
        String type = this.settings.getString(STANDING).toLowerCase();
        this.negated = type.startsWith("not");
        this.in = type.endsWith("in block");
        this.types = this.settings.getStringList(MATERIAL).stream().map(s -> s.toUpperCase().replace(' ', '_')).collect(Collectors.toSet());
    }

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        Block in = target.getLocation().getBlock();
        Block tested = this.in ? in : in.getRelative(BlockFace.DOWN);
        return this.negated != this.types.contains(tested.getType().name());
    }
}

