/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.data.io;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;
import com.sucy.skill.api.player.PlayerAccounts;
import com.sucy.skill.api.player.PlayerClass;
import com.sucy.skill.api.player.PlayerCombos;
import com.sucy.skill.api.player.PlayerData;
import com.sucy.skill.api.player.PlayerSkill;
import com.sucy.skill.api.player.PlayerSkillBar;
import com.sucy.skill.api.skills.Skill;
import com.sucy.skill.cast.CastMode;
import com.sucy.skill.listener.MainListener;
import com.sucy.skill.log.Logger;
import com.sucy.skill.manager.ComboManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;

public abstract class IOManager {
    private static final String LIMIT = "limit";
    private static final String ACTIVE = "active";
    private static final String ACCOUNTS = "accounts";
    private static final String ACCOUNT_PREFIX = "acc";
    private static final String HEALTH = "health";
    private static final String MANA = "mana";
    private static final String CLASSES = "classes";
    private static final String SKILLS = "skills";
    private static final String BINDS = "binds";
    private static final String LEVEL = "level";
    private static final String EXP = "exp";
    private static final String POINTS = "points";
    private static final String SKILL_BAR = "bar";
    private static final String HOVER = "hover";
    private static final String EXTRA = "extra";
    private static final String INSTANT = "instant";
    private static final String TEXT_LAYOUT = "text-layout";
    private static final String ENABLED = "enabled";
    private static final String SLOTS = "slots";
    private static final String UNASSIGNED = "e";
    private static final String COMBOS = "combos";
    private static final String ATTRIBS = "attribs";
    private static final String COOLDOWN = "cd";
    private static final String HUNGER = "hunger";
    private static final String ATTRIB_POINTS = "attrib-points";
    protected final SkillAPI api;

    IOManager(SkillAPI api) {
        this.api = api;
    }

    public abstract HashMap<String, PlayerAccounts> loadAll();

    public abstract PlayerAccounts loadData(OfflinePlayer var1);

    public abstract void saveData(PlayerAccounts var1);

    public void saveAll() {
        for (PlayerAccounts data : SkillAPI.getPlayerAccountData().values()) {
            if (!data.isLoaded() || MainListener.loadingPlayers.containsKey(data.getOfflinePlayer().getUniqueId())) continue;
            this.saveData(data);
        }
    }

    protected PlayerAccounts load(OfflinePlayer player, DataSection file) {
        PlayerAccounts data = new PlayerAccounts(player);
        DataSection accounts = file.getSection(ACCOUNTS);
        if (accounts == null) {
            data.getActiveData().endInit();
            data.isLoaded(true);
            return data;
        }
        for (String accountKey : accounts.keys()) {
            DataSection skills;
            DataSection account = accounts.getSection(accountKey);
            PlayerData acc = null;
            try {
                acc = data.getData(Integer.parseInt(accountKey.replace(ACCOUNT_PREFIX, "")), player, true);
            }
            catch (NumberFormatException e) {
                Logger.bug("Could not parse account key '" + accountKey + "' for player " + player.getUniqueId());
                Logger.bug("This is related to ticket #154. Please paste the player's file and this stack trace.");
                Logger.bug("https://github.com/promcteam/proskillapi/issues/154");
                e.printStackTrace();
            }
            DataSection classes = account.getSection(CLASSES);
            if (classes != null) {
                for (Object classKey : classes.keys()) {
                    RPGClass rpgClass = SkillAPI.getClass((String)classKey);
                    if (rpgClass == null) continue;
                    PlayerClass c = acc.setClass(null, rpgClass, true);
                    DataSection classData = classes.getSection((String)classKey);
                    int levels = classData.getInt(LEVEL);
                    if (levels > 0) {
                        c.setLevel(levels);
                    }
                    c.setPoints(classData.getInt(POINTS));
                    if (classData.has("total-exp")) {
                        c.setExp(classData.getDouble("total-exp") - c.getTotalExp());
                        continue;
                    }
                    c.setExp(classData.getDouble(EXP));
                }
            }
            if ((skills = account.getSection(SKILLS)) != null) {
                Object classKey;
                classKey = skills.keys().iterator();
                while (classKey.hasNext()) {
                    String skillKey = (String)classKey.next();
                    DataSection skill = skills.getSection(skillKey);
                    PlayerSkill skillData = acc.getSkill(skillKey);
                    if (skillData == null) continue;
                    skillData.setLevel(skill.getInt(LEVEL));
                    skillData.addCooldown(skill.getInt(COOLDOWN, 0));
                }
            }
            if (SkillAPI.getSettings().isSkillBarEnabled() || SkillAPI.getSettings().getCastMode().equals((Object)CastMode.COMBAT)) {
                DataSection skillBar = account.getSection(SKILL_BAR);
                PlayerSkillBar bar = acc.getSkillBar();
                if (skillBar != null && bar != null) {
                    boolean enabled = skillBar.getBoolean(ENABLED, true);
                    for (String key : skillBar.keys()) {
                        boolean[] locked = SkillAPI.getSettings().getLockedSlots();
                        if (key.equals(SLOTS)) {
                            for (int i = 0; i < 9; ++i) {
                                if (bar.isWeaponSlot(i) || locked[i]) continue;
                                bar.getData().remove(i + 1);
                            }
                            List slots = skillBar.getList(SLOTS);
                            for (String slot : slots) {
                                int i = Integer.parseInt(slot);
                                if (locked[i - 1]) continue;
                                bar.getData().put(i, UNASSIGNED);
                            }
                            continue;
                        }
                        if (SkillAPI.getSkill(key) == null) continue;
                        bar.getData().put(skillBar.getInt(key), key);
                    }
                    bar.applySettings();
                }
            }
            if (SkillAPI.getSettings().isCustomCombosAllowed()) {
                DataSection combos = account.getSection(COMBOS);
                PlayerCombos comboData = acc.getComboData();
                ComboManager cm = SkillAPI.getComboManager();
                if (combos != null && comboData != null) {
                    for (String key : combos.keys()) {
                        Skill skill = SkillAPI.getSkill(key);
                        if (!acc.hasSkill(key) || skill == null || !skill.canCast()) continue;
                        int combo = cm.parseCombo(combos.getString(key));
                        if (combo == -1) {
                            Logger.invalid("Invalid skill combo: " + combos.getString(key));
                            continue;
                        }
                        comboData.setSkill(skill, combo);
                    }
                }
            }
            if (SkillAPI.getSettings().isAttributesEnabled()) {
                acc.setAttribPoints(account.getInt(ATTRIB_POINTS, 0));
                DataSection attribs = account.getSection(ATTRIBS);
                if (attribs != null) {
                    for (String key : attribs.keys()) {
                        acc.getAttributeData().put(key, attribs.getInt(key));
                    }
                }
            }
            if (SkillAPI.getSettings().isCastEnabled()) {
                switch (SkillAPI.getSettings().getCastMode()) {
                    case BARS: {
                        acc.getCastBars().reset();
                        acc.getCastBars().load(account.getSection(HOVER), true);
                        acc.getCastBars().load(account.getSection(INSTANT), false);
                        break;
                    }
                    case ACTION_BAR: 
                    case TITLE: 
                    case SUBTITLE: 
                    case CHAT: {
                        acc.getTextCastingData().load(account.getSection(TEXT_LAYOUT));
                    }
                }
            }
            acc.setHungerValue(account.getDouble(HUNGER, 1.0));
            if (account.has(EXTRA) && account.getSection(EXTRA) != null) {
                acc.getExtraData().applyDefaults(account.getSection(EXTRA));
            }
            acc.endInit();
            DataSection binds = account.getSection(BINDS);
            if (binds == null) continue;
            for (String bindKey : binds.keys()) {
                acc.bind(Material.valueOf((String)bindKey), acc.getSkill(binds.getString(bindKey)));
            }
        }
        data.setAccount(file.getInt(ACTIVE, data.getActiveId()), false);
        data.getActiveData().setLastHealth(file.getDouble(HEALTH));
        data.getActiveData().setMana(file.getDouble(MANA, data.getActiveData().getMana()));
        data.isLoaded(true);
        return data;
    }

    protected DataSection save(PlayerAccounts data) {
        try {
            DataSection file = new DataSection();
            file.set(LIMIT, (Object)data.getAccountLimit());
            file.set(ACTIVE, (Object)data.getActiveId());
            file.set(HEALTH, (Object)data.getActiveData().getLastHealth());
            file.set(MANA, (Object)data.getActiveData().getMana());
            DataSection accounts = file.createSection(ACCOUNTS);
            for (Map.Entry<Integer, PlayerData> entry : data.getAllData().entrySet()) {
                Object skill2;
                DataSection account = accounts.createSection(ACCOUNT_PREFIX + entry.getKey());
                PlayerData acc = entry.getValue();
                DataSection classes = account.createSection(CLASSES);
                for (PlayerClass playerClass : acc.getClasses()) {
                    DataSection classSection = classes.createSection(playerClass.getData().getName());
                    classSection.set(LEVEL, (Object)playerClass.getLevel());
                    classSection.set(POINTS, (Object)playerClass.getPoints());
                    classSection.set(EXP, (Object)playerClass.getExp());
                }
                DataSection skills = account.createSection(SKILLS);
                for (Object skill2 : acc.getSkills()) {
                    if (((PlayerSkill)skill2).isExternal()) continue;
                    DataSection dataSection = skills.createSection(((PlayerSkill)skill2).getData().getName());
                    dataSection.set(LEVEL, (Object)((PlayerSkill)skill2).getLevel());
                    if (!((PlayerSkill)skill2).isOnCooldown()) continue;
                    dataSection.set(COOLDOWN, (Object)((PlayerSkill)skill2).getCooldown());
                }
                DataSection dataSection = account.createSection(BINDS);
                skill2 = acc.getBinds().entrySet().iterator();
                while (skill2.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)skill2.next();
                    if (entry2.getKey() == null || entry2.getValue() == null) continue;
                    dataSection.set(((Material)entry2.getKey()).name(), (Object)((PlayerSkill)entry2.getValue()).getData().getName());
                }
                if ((SkillAPI.getSettings().isSkillBarEnabled() || SkillAPI.getSettings().getCastMode().equals((Object)CastMode.COMBAT)) && acc.getSkillBar() != null) {
                    DataSection skillBar = account.createSection(SKILL_BAR);
                    PlayerSkillBar playerSkillBar = acc.getSkillBar();
                    skillBar.set(ENABLED, (Object)playerSkillBar.isEnabled());
                    skillBar.set(SLOTS, new ArrayList<Integer>(playerSkillBar.getData().keySet()));
                    for (Map.Entry<Integer, String> slotEntry : playerSkillBar.getData().entrySet()) {
                        if (slotEntry.getValue().equals(UNASSIGNED)) continue;
                        skillBar.set(slotEntry.getValue(), (Object)slotEntry.getKey());
                    }
                }
                if (SkillAPI.getSettings().isCustomCombosAllowed()) {
                    DataSection combos = account.createSection(COMBOS);
                    PlayerCombos playerCombos = acc.getComboData();
                    ComboManager cm = SkillAPI.getComboManager();
                    if (combos != null && playerCombos != null) {
                        HashMap<Integer, String> comboMap = playerCombos.getSkillMap();
                        for (Map.Entry<Integer, String> combo : comboMap.entrySet()) {
                            combos.set(combo.getValue(), (Object)cm.getSaveString(combo.getKey()));
                        }
                    }
                }
                if (SkillAPI.getSettings().isAttributesEnabled()) {
                    account.set(ATTRIB_POINTS, (Object)acc.getAttributePoints());
                    DataSection attribs = account.createSection(ATTRIBS);
                    for (String key : acc.getAttributeData().keySet()) {
                        attribs.set(key, (Object)acc.getAttributeData().get(key));
                    }
                }
                if (SkillAPI.getSettings().isCastEnabled()) {
                    switch (SkillAPI.getSettings().getCastMode()) {
                        case BARS: {
                            acc.getCastBars().save(account.createSection(HOVER), true);
                            acc.getCastBars().save(account.createSection(INSTANT), false);
                            break;
                        }
                        case ACTION_BAR: 
                        case TITLE: 
                        case SUBTITLE: 
                        case CHAT: {
                            acc.getTextCastingData().save(account.createSection(TEXT_LAYOUT));
                        }
                    }
                }
                account.set(HUNGER, (Object)acc.getHungerValue());
                if (acc.getExtraData().size() <= 0) continue;
                account.set(EXTRA, (Object)acc.getExtraData());
            }
            return file;
        }
        catch (Exception ex) {
            Logger.bug("Failed to save player data for " + data.getPlayer().getName());
            ex.printStackTrace();
            return null;
        }
    }
}

