/*
 * Decompiled with CFR 0.152.
 */
package com.sucy.skill.data.io;

import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.player.PlayerAccounts;
import com.sucy.skill.data.io.IOManager;
import com.sucy.skill.log.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import mc.promcteam.engine.mccore.config.CommentedConfig;
import mc.promcteam.engine.mccore.config.parse.DataSection;
import mc.promcteam.engine.mccore.util.VersionManager;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigIO
extends IOManager {
    public ConfigIO(SkillAPI plugin) {
        super(plugin);
    }

    @Override
    public HashMap<String, PlayerAccounts> loadAll() {
        HashMap<String, PlayerAccounts> result = new HashMap<String, PlayerAccounts>();
        for (Player player : VersionManager.getOnlinePlayers()) {
            result.put(player.getUniqueId().toString().toLowerCase(), this.loadData((OfflinePlayer)player));
        }
        return result;
    }

    @Override
    public PlayerAccounts loadData(OfflinePlayer player) {
        String playerKey = player.getUniqueId().toString().toLowerCase();
        CommentedConfig config = new CommentedConfig((JavaPlugin)this.api, "players/" + playerKey);
        CommentedConfig nameConfig = new CommentedConfig((JavaPlugin)this.api, "players/" + player.getName());
        if (!playerKey.equals(player.getName()) && nameConfig.getConfigFile().exists()) {
            DataSection old = nameConfig.getConfig();
            for (String key : old.keys()) {
                config.getConfig().set(key, old.get(key));
            }
            nameConfig.getConfigFile().delete();
        }
        DataSection file = config.getConfig();
        return this.load(player, file);
    }

    @Override
    public void saveData(PlayerAccounts data) {
        if (!data.isLoaded()) {
            return;
        }
        try {
            CommentedConfig config = new CommentedConfig((JavaPlugin)this.api, "players/" + data.getOfflinePlayer().getUniqueId().toString().toLowerCase());
            config.clear();
            DataSection file = this.save(data);
            config.getConfig().applyDefaults(file);
            config.save();
        }
        catch (Exception ex) {
            Logger.bug("Failed to save data for invalid player");
        }
    }

    @Override
    public void saveAll() {
        HashMap<String, PlayerAccounts> data = SkillAPI.getPlayerAccountData();
        ArrayList<String> keys = new ArrayList<String>(data.keySet());
        for (String key : keys) {
            this.saveData(data.get(key));
        }
    }
}

